/*
 * Decompiled with CFR 0.152.
 */
package notify;

import java.sql.SQLException;
import java.sql.Statement;
import notify.JDBCStatementTimeout;

public class JDBCStatementTimeoutThread
extends Thread
implements JDBCStatementTimeout {
    private Statement waitingFor;
    private SQLException lastException;
    long timeRemainingMs;
    long endMillis;

    public JDBCStatementTimeoutThread() {
        this.setName(JDBCStatementTimeoutThread.class.getName());
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            while (this.waitingFor != null && this.timeRemainingMs >= 0L) {
                this.timeRemainingMs = this.endMillis - System.currentTimeMillis();
                try {
                    this.wait(this.timeRemainingMs);
                }
                catch (InterruptedException e) {}
            }
            this.lastException = null;
            if (this.waitingFor == null) continue;
            try {
                try {
                    this.waitingFor.cancel();
                    continue;
                }
                finally {
                    this.waitingFor = null;
                    continue;
                }
            }
            catch (SQLException e) {
                this.lastException = e;
                continue;
            }
            break;
        }
    }

    public synchronized void statementStarting(Statement stmt, int timeoutSeconds) {
        if (this.waitingFor != null) {
            throw new IllegalStateException("Already waiting for completion of statement " + this.waitingFor);
        }
        this.waitingFor = stmt;
        this.timeRemainingMs = timeoutSeconds * 1000;
        this.endMillis = System.currentTimeMillis() + this.timeRemainingMs;
        this.notifyAll();
    }

    public synchronized SQLException statementDone(Statement stmt) {
        if (this.waitingFor != null && this.waitingFor != stmt) {
            throw new IllegalStateException("Statement reported as done, " + stmt + ", was not statement waited for " + this.waitingFor);
        }
        SQLException lastExc = this.lastException;
        this.waitingFor = null;
        this.lastException = null;
        this.notifyAll();
        return lastExc;
    }

    public boolean isWaiting() {
        return this.waitingFor != null;
    }
}

