/*
 * Decompiled with CFR 0.152.
 */
package notify;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PgNotificationHelper {
    private final Set<String> listenedNames = new HashSet<String>();
    private final List<PgNotificationListener> listeners = new ArrayList<PgNotificationListener>();

    public void listen(Connection conn, String name) throws SQLException {
        this.listenedNames.add(name);
        this.sendListens(conn, Arrays.asList(name));
    }

    public void listen(Connection conn, Collection<String> names) throws SQLException {
        this.listenedNames.addAll(names);
        this.sendListens(conn, names);
    }

    public void unlisten(Connection conn, String name) throws SQLException {
        this.listenedNames.remove(name);
        this.sendUnlistens(conn, Arrays.asList(name));
    }

    public void unlisten(Connection conn, Collection<String> names) throws SQLException {
        this.listenedNames.removeAll(names);
        this.sendUnlistens(conn, names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotify(Connection conn, String name) throws SQLException {
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.execute("NOTIFY " + name + ";");
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void unlistenAll(Connection conn) throws SQLException {
        this.listenedNames.clear();
        this.relisten(conn);
    }

    public void relisten(Connection conn) throws SQLException {
        Set<String> dbListenedNames = this.getDbListenedNames(conn);
        HashSet<String> namesToAdd = new HashSet<String>(this.listenedNames);
        namesToAdd.removeAll(dbListenedNames);
        this.sendListens(conn, namesToAdd);
        dbListenedNames.removeAll(this.listenedNames);
        this.sendUnlistens(conn, dbListenedNames);
    }

    public void relisten(Connection conn, Collection<String> newListenedNames) throws SQLException {
        this.listenedNames.clear();
        this.listenedNames.addAll(newListenedNames);
        this.relisten(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(Connection conn, long pg_backend_pid, boolean useDummyStatement) throws SQLException {
        PGNotification[] notifications;
        if (useDummyStatement) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute("");
            }
            finally {
                stmt.close();
            }
        }
        if ((notifications = ((PGConnection)((Object)conn)).getNotifications()) != null) {
            List<PGNotification> notificationView = Collections.unmodifiableList(Arrays.asList(notifications));
            for (PgNotificationListener l : this.listeners) {
                l.notified(this, pg_backend_pid, notificationView);
            }
        }
    }

    public void addNotificationListener(PgNotificationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener may not be null");
        }
        this.listeners.add(listener);
    }

    public void removeNotificationListener(PgNotificationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener may not be null");
        }
        this.listeners.remove(listener);
    }

    public void clearNotificationListeners() {
        this.listeners.clear();
    }

    public Set<String> getListenedNames() {
        return Collections.unmodifiableSet(this.listenedNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDbListenedNames(Connection conn) throws SQLException {
        HashSet<String> names = new HashSet<String>();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT relname FROM pg_catalog.pg_listener WHERE listenerpid = pg_backend_pid();");
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
        return names;
    }

    private void sendListens(Connection conn, Collection<String> names) throws SQLException {
        if (names.isEmpty()) {
            return;
        }
        this.sendListenControlCommands(conn, Collections.unmodifiableCollection(names), true);
    }

    private void sendUnlistens(Connection conn, Collection<String> names) throws SQLException {
        if (names.isEmpty()) {
            return;
        }
        this.sendListenControlCommands(conn, Collections.unmodifiableCollection(names), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendListenControlCommands(Connection conn, Collection<String> names, boolean shouldListen) throws SQLException {
        this.assertSafeIdentifiers(names);
        Statement stmt = conn.createStatement();
        String cmd = shouldListen ? "LISTEN " : "UNLISTEN ";
        try {
            for (String name : names) {
                stmt.addBatch(cmd + name);
            }
            stmt.executeBatch();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        for (PgNotificationListener l : this.listeners) {
            if (shouldListen) {
                l.listenersAdded(this, conn, names);
                continue;
            }
            l.listenersRemoved(this, conn, names);
        }
    }

    private void assertSafeIdentifiers(Collection<String> names) throws IllegalArgumentException {
        for (String n : names) {
            boolean ok = n.indexOf(59) == -1;
            if (ok) continue;
            throw new IllegalArgumentException("Name \"" + n + "\" is not a valid identifier for LISTEN");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PgNotificationListener {
        public void notified(PgNotificationHelper var1, long var2, List<PGNotification> var4);

        public void listenersAdded(PgNotificationHelper var1, Connection var2, Collection<String> var3);

        public void listenersRemoved(PgNotificationHelper var1, Connection var2, Collection<String> var3);
    }
}

