#ifndef _WAL_BCE_DMA_HEADER_FILE_
#define _WAL_BCE_DMA_HEADER_FILE_

#include <xbasic_types.h>
#include "wal_bce_jsy.h"

#define WAL_DMA_MAX_CHANNELS     8
#define WAL_DMA_REQ_WR         0x0
#define WAL_DMA_REQ_RD         0x1
#define WAL_DMA_REQ_IRQ        0x2
#define WAL_DMA_REQ_STRUPDATE  0x4
#define WAL_DMA_REQ_BRAMUPDATE 0x8

extern const struct wal_family_desc wal_BCE_DMA_GENERIC_4D_description_structure;

#define WAL_BCE_DMA_GENERIC_4D_MAX_SIMD             WAL_BCE_JSY_MAX_SIMD
#define WAL_BCE_DMA_GENERIC_4D_DMEM_NUM_MEMORIES    WAL_BCE_JSY_GENERIC_4D_SMEM_NUM_MEMORIES
#define WAL_BCE_DMA_GENERIC_4D_CMEM_NUM_MEMORIES    WAL_BCE_JSY_GENERIC_4D_CMEM_NUM_MEMORIES
#define WAL_BCE_DMA_GENERIC_4D_SMEM_NUM_MEMORIES    WAL_BCE_JSY_SMEM_NUM_MEMORIES

int wal_dma_configure(struct wal_worker *wrk, uint8_t channel, void *ddraddr, unsigned int simdidx, unsigned int bramidx, unsigned int bramaddr, uint16_t len);
int wal_dma_start(struct wal_worker *wrk, uint8_t channel, uint8_t mode);
uint8_t wal_dma_isbusy(struct wal_worker *wrk, uint8_t chmask);


#endif /* _WAL_BCE_DMA_HEADER_FILE_ */
