#ifndef _BCE_DMA_CONFIGURATION_TABLE_
#define _BCE_DMA_CONFIGURATION_TABLE_


/* enumeration of BCE operations */
enum bce_dma_bank4_operations {
  BCE_DFU_OP_VCPY    = 1,
  BCE_DFU_OP_VADD    = 2,
  BCE_DFU_OP_VMUL    = 3,
  BCE_DFU_OP_VMAC    = 4,
  BCE_DFU_OP_DPROD   = 5,
  BCE_DFU_OP_VSUB    = 6,
  BCE_DFU_OP_VMSUBAC = 24,
};

/* enumeration of BCE capabilities - bit masks for testing BCE capability */
enum bce_dma_bank4_capabilities {
  BCE_CAP_NONE    = 0x00000000,
  BCE_CAP_VVER    = 0x00000001,
  BCE_CAP_VCPY    = 0x00000002,
  BCE_CAP_VADD    = 0x00000004,
  BCE_CAP_VMUL    = 0x00000008,
  BCE_CAP_VMAC    = 0x00000010,
  BCE_CAP_DPROD   = 0x00000020,
  BCE_CAP_VSUB    = 0x00000040,
  BCE_CAP_VMSUBAC = 0x01000000,
};


extern void *bce_dma_cfgtable[];
extern int bce_dma_cfgtable_items;

#endif /* _BCE_DMA_CONFIGURATION_TABLE_ */
