
#ifndef WAL_BCE_JSY_H
#define WAL_BCE_JSY_H


/*
 * For the BCE_JSY_* worker family the following macros must be defined:
 * WAL_BCE_JSY_*_MAX_SIMD
 * WAL_BCE_JSY_*_DMEM_NUM_MEMORIES
 * WAL_BCE_JSY_*_CMEM_NUM_MEMORIES
 * WAL_BCE_JSY_*_SMEM_NUM_MEMORIES
 * wal_BCE_JSY_*_description_structure
 */

/* worker family ID */
/**
 * enum wal_bce_jsy_family_ids - family identifications in the BCE_JSY group of families
 */
enum wal_bce_jsy_family_ids {
    WAL_BCE_JSY_ID_UNKNOWN = 0,
    //WAL_BCE_JSY_ID_TRIVIAL = 1,
    WAL_BCE_JSY_ID_GENERIC_3D = 1,
    WAL_BCE_JSY_ID_GENERIC_4D = 2,
};


// Position of info register in PB CFG Memory, Output region (which starts at the word 0x80)
#define WAL_BCE_JSY_INFO_REG_ADDR    1
// Position of work register in PB output memory
// #define WAL_BCE_HK_WORK_REG_ADDR    254

#define WAL_BCE_JSY_ID_FAMILY_MASK   0x0000ff00
#define WAL_BCE_JSY_ID_FAMILY_SHIFT   8
#define WAL_BCE_JSY_ID_DFUKIND_MASK     0x000000ff
#define WAL_BCE_JSY_ID_DFUKIND_SHIFT    0
/*
 *
 */
#define wal_bce_jsy_family(id)          (((id) & WAL_BCE_JSY_ID_FAMILY_MASK) >> WAL_BCE_JSY_ID_FAMILY_SHIFT)
#define wal_bce_jsy_dfukind(id)         (((id) & WAL_BCE_JSY_ID_DFUKIND_MASK) >> WAL_BCE_JSY_ID_DFUKIND_SHIFT)
#define wal_bce_jsy_extid_num_ags(id)   ( ((id) >> 16) & 0x0f )
#define wal_bce_jsy_extid_num_idxags(id)        ( ((id) >> 20) & 0x0f )
#define wal_bce_jsy_extid_num_dtmems(id)        ( ((id) >> 8) & 0xff )

/* control memories */
// #define WAL_BCE_JSY_TRIVIAL_CMEM_NUM_MEMORIES    WAL_CMEM_NUM_MEMORIES
#define WAL_BCE_JSY_GENERIC_3D_CMEM_NUM_MEMORIES    WAL_CMEM_NUM_MEMORIES
#define WAL_BCE_JSY_GENERIC_4D_CMEM_NUM_MEMORIES     WAL_CMEM_NUM_MEMORIES

/* data memories */
#define WAL_BCE_JSY_MAX_SIMD     1
// #define WAL_BCE_JSY_TRIVIAL_MAX_SIMD     WAL_BCE_JSY_MAX_SIMD  /* must be defined for checking if registered worker doesn't want more than this */
#define WAL_BCE_JSY_GENERIC_3D_MAX_SIMD     WAL_BCE_JSY_MAX_SIMD  /* must be defined for checking if registered worker doesn't want more than this */
#define WAL_BCE_JSY_GENERIC_4D_MAX_SIMD     WAL_BCE_JSY_MAX_SIMD  /* must be defined for checking if registered worker doesn't want more than this */

/**
 * enum wal_bce_jsy_data_memories - indices to BCE_JSY data memories
 * @WAL_BCE_JSY_DMEM_A: index of the A data memory
 * @WAL_BCE_JSY_DMEM_B: index of the B data memory
 * @WAL_BCE_JSY_DMEM_C: index of the C data memory
 * @WAL_BCE_JSY_DMEM_D: index of the D data memory
 * @WAL_BCE_JSY_DMEM_NUM_MEMORIES: number of data memories in the BCE_JSY families
 */
enum wal_bce_jsy_data_memories {
        WAL_BCE_JSY_DMEM_A = 0,
        WAL_BCE_JSY_DMEM_B,
        WAL_BCE_JSY_DMEM_C,
        WAL_BCE_JSY_DMEM_D,
        WAL_BCE_JSY_DMEM_NUM_MEMORIES
};
// #define WAL_BCE_JSY_TRIVIAL_DMEM_NUM_MEMORIES    WAL_BCE_JSY_DMEM_NUM_MEMORIES
#define WAL_BCE_JSY_GENERIC_3D_DMEM_NUM_MEMORIES    WAL_BCE_JSY_DMEM_NUM_MEMORIES
#define WAL_BCE_JSY_GENERIC_4D_DMEM_NUM_MEMORIES    WAL_BCE_JSY_DMEM_NUM_MEMORIES

/* data memories length */
// #define WAL_BCE_JSY_TRIVIAL_DMEM_LENGTH          1024
#define WAL_BCE_JSY_GENERIC_3D_DMEM_LENGTH          1024
#define WAL_BCE_JSY_GENERIC_4D_DMEM_LENGTH          1024

/* support memories */
#define WAL_BCE_JSY_SMEM_NUM_MEMORIES    0
// #define WAL_BCE_JSY_TRIVIAL_SMEM_NUM_MEMORIES    WAL_BCE_JSY_SMEM_NUM_MEMORIES
#define WAL_BCE_JSY_GENERIC_3D_SMEM_NUM_MEMORIES    WAL_BCE_JSY_SMEM_NUM_MEMORIES
#define WAL_BCE_JSY_GENERIC_4D_SMEM_NUM_MEMORIES    WAL_BCE_JSY_SMEM_NUM_MEMORIES

/******************************************************************************/
/* BCE_JSY worker specific operations and capabilities */
/**
 * enum wal_bce_jsy_operation_codes - worker operations known to BCE_JSY group of families
 * @WAL_BCE_JSY_OP_VCPY: copy vector    M0[i] <= M1[j]
 * @WAL_BCE_JSY_OP_VADD: add vectors    M0[i] <= M1[j] + M2[k]
 */
enum wal_bce_jsy_operation_codes {
    /* the first op-code should start at WAL_OP_FIRST_USER_CODE */
    WAL_BCE_JSY_OP_VCPY   = 0x03,       /* copy vector    M0[i] <= M1[j]            */
    WAL_BCE_JSY_OP_VADD   = 0x04,       /* add vectors    M0[i] <= M1[j] + M2[k]    */
    WAL_BCE_JSY_OP_RUNX   = 0x05,       /* directly run an operation */
};

/* BCE_JSY worker capabilities */
/**
 * enum wal_bce_jsy_capabilities - BCE_JSY possible worker capabilities 
 * @WAL_BCE_JSY_CAP_NONE: supported NONE :-)
 * @WAL_BCE_JSY_CAP_VCPY: supported VCPY
 * @WAL_BCE_JSY_CAP_VADD: supported VADD
 */
enum wal_bce_jsy_capabilities {
    WAL_BCE_JSY_CAP_NONE   = 0x00000000,
    WAL_BCE_JSY_CAP_VCPY   = 0x00000001,
    WAL_BCE_JSY_CAP_VADD   = 0x00000002,
};

/* name of the CE description structure must be wal_<name of CE>_description_structure */
// extern const struct wal_family_desc wal_BCE_JSY_TRIVIAL_description_structure;
extern const struct wal_family_desc wal_BCE_JSY_GENERIC_3D_description_structure;
extern const struct wal_family_desc wal_BCE_JSY_GENERIC_4D_description_structure;


#endif
