#ifndef _BCE_DMA_CONFIGURATION_TABLE_
#define _BCE_DMA_CONFIGURATION_TABLE_


/* enumeration of BCE operations */
enum bce_dma_bank4_operations {
  BCE_DFU_OP_VCPY     =  1,
  BCE_DFU_OP_VADD     =  2,
  BCE_DFU_OP_VMUL     =  3,
  BCE_DFU_OP_VMAC     =  4,
  BCE_DFU_OP_DPROD    =  5,
  BCE_DFU_OP_VSUB     =  6,
  BCE_DFU_OP_VSUM     =  7,
  BCE_DFU_OP_VCMPLT   =  8,
  BCE_DFU_OP_VSAD     =  9,
  BCE_DFU_OP_VMAX     = 10,
  BCE_DFU_OP_VMIN     = 11,
  BCE_DFU_OP_INDEXMAX = 12,
  BCE_DFU_OP_INDEXMIN = 13,
  BCE_DFU_OP_VSQR     = 14,
  BCE_DFU_OP_VSELECT  = 15,
  BCE_DFU_OP_VGTE     = 16,
  BCE_DFU_OP_VLTE     = 17,
  BCE_DFU_OP_VBAND    = 18,
  BCE_DFU_OP_VBOR     = 19,
  BCE_DFU_OP_VBNOT    = 20,
  BCE_DFU_OP_VCONVR   = 21,
  BCE_DFU_OP_VCONVG   = 22,
  BCE_DFU_OP_VCONVB   = 23,
  BCE_DFU_OP_VMSUBAC  = 24,
  BCE_DFU_OP_VAND3E   = 25,
  BCE_DFU_OP_VAND3V   = 26,
  BCE_DFU_OP_VOR3E    = 27,
  BCE_DFU_OP_VOR3V    = 28
};

/* enumeration of BCE capabilities - bit masks for testing BCE capability */
enum bce_dma_bank4_capabilities {
  BCE_CAP_NONE     = 0x00000000,
  BCE_CAP_VVER     = 0x00000001,
  BCE_CAP_VCPY     = 0x00000002,
  BCE_CAP_VADD     = 0x00000004,
  BCE_CAP_VMUL     = 0x00000008,
  BCE_CAP_VMAC     = 0x00000010,
  BCE_CAP_DPROD    = 0x00000020,
  BCE_CAP_VSUB     = 0x00000040,

  BCE_CAP_VSUM     = 0x00000080,
  BCE_CAP_VCMPLT   = 0x00000100,
  BCE_CAP_VSAD     = 0x00000200,
  BCE_CAP_VMAX     = 0x00000400,
  BCE_CAP_VMIN     = 0x00000800,
  BCE_CAP_INDEXMAX = 0x00001000,
  BCE_CAP_INDEXMIN = 0x00002000,
  BCE_CAP_VSQR     = 0x00004000,
  BCE_CAP_VSELECT  = 0x00008000,
  BCE_CAP_VGTE     = 0x00010000,
  BCE_CAP_VLTE     = 0x00020000,
  BCE_CAP_VBAND    = 0x00040000,
  BCE_CAP_VBOR     = 0x00080000,
  BCE_CAP_VBNOT    = 0x00100000,
  BCE_CAP_VCONVR   = 0x00200000,
  BCE_CAP_VCONVG   = 0x00400000,
  BCE_CAP_VCONVB   = 0x00800000,
  BCE_CAP_VMSUBAC  = 0x01000000,
  BCE_CAP_VAND3E   = 0x02000000,
  BCE_CAP_VAND3V   = 0x04000000,
  BCE_CAP_VOR3E    = 0x08000000,
  BCE_CAP_VOR3V    = 0x10000000,
};


extern void *bce_dma_cfgtable[];
extern int bce_dma_cfgtable_items;

#define BCE_DMA_CFGTABLE_NUM_ITEMS  2


#endif /* _BCE_DMA_CONFIGURATION_TABLE_ */
