#!/bin/bash
# RAVAC tools build script

LLVM_SRC="llvm-3.0.src"

mkdir -p llvm_obj
cd llvm_obj

# first configure LLVM
../$LLVM_SRC/configure --disable-optimized --enable-targets=cbe,codasip --enable-assertions --enable-debug-symbols --enable-expensive-checks --prefix=`pwd`/../llvm_install  || exit 1
mkdir -p lib/Target/Codasip/

#first build will fail - we need just to create directories and Makefiles so the newer ones are not rewritten
make PREPARE_LIB_ONLY=1
echo "This build was supposed to fail" 

# then add firmware generation backend files 
# must be copied with all sources
cp -R ../$LLVM_SRC/lib/Target/Codasip/* lib/Target/Codasip/  || exit 1

#and now this build will complete successfully, needs to be cleaned otherwise messages about incompatible libraries occur
make clean
make -j 5 || exit 1

make install

export RAVAC_BASE_PATH=`pwd`