/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#ifndef CODASIPGENISELLOWERING_H
#define CODASIPGENISELLOWERING_H

#include "llvm/CodeGen/SelectionDAG.h"
#include "llvm/CodeGen/SelectionDAGISel.h"
#include "llvm/CodeGen/MachineInstr.h"
#include "llvm/CodeGen/MachineBasicBlock.h"
#include "llvm/Target/TargetLowering.h"

#include "Codasip.h"

namespace llvm {
  namespace CodasipISD {
    /// extra node types that are used for creation of abstract operations (generally used for all targets)
    enum NodeType {
      FIRST_NUMBER = ISD::BUILTIN_OP_END,
      Call,
      Ret,
      /// wrapper of global symbols adressed through pointer type imm
      GAWrap,
      LAST_NUMBER
    };
  }

  class CodasipGenTargetLowering: public TargetLowering {

    public:
      explicit CodasipGenTargetLowering(CodasipTargetMachine &TM);

      virtual unsigned getFunctionAlignment(const Function *) const;

      virtual SDValue
      LowerFormalArguments(SDValue Chain, CallingConv::ID CallConv, bool isVarArg, const SmallVectorImpl<ISD::InputArg> &Ins,
                           DebugLoc dl, SelectionDAG &DAG, SmallVectorImpl<SDValue> &InVals) const;

      virtual SDValue
      LowerCall(SDValue Chain, SDValue Callee, CallingConv::ID CallConv, bool isVarArg, bool &isTailCall,
                const SmallVectorImpl<ISD::OutputArg> &Outs, const SmallVectorImpl<SDValue> &OutVals,
                const SmallVectorImpl<ISD::InputArg> &Ins, DebugLoc dl, SelectionDAG &DAG, SmallVectorImpl<SDValue> &InVals) const;

      virtual SDValue
      LowerReturn(SDValue Chain, CallingConv::ID CallConv, bool isVarArg, const SmallVectorImpl<ISD::OutputArg> &Outs,
                  const SmallVectorImpl<SDValue> &OutVals, DebugLoc dl, SelectionDAG &DAG) const;

      virtual SDValue LowerOperation(SDValue Op, SelectionDAG &DAG) const;

      virtual const char* getTargetNodeName(unsigned Opcode) const;

      virtual const char* getPassName() const {return "Codasip lowering pass.";}

      std::pair<unsigned, const TargetRegisterClass*>
      getRegForInlineAsmConstraint(const std::string &Constraint, EVT VT) const;

      MachineBasicBlock* EmitInstrWithCustomInserter(MachineInstr *MI, MachineBasicBlock *BB) const;

      //virtual MVT::SimpleValueType getSetCCResultType(EVT VT) const;
  };
  
}

#endif
