/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

// Codasip assembler uses GAS standards.

#include "CodasipMCAsmInfo.h"

llvm::CodasipTargetAsmInfo::CodasipTargetAsmInfo(const Target &T, const StringRef &TT)
{
  // this kind of comment is supported always
  CommentString = "// ";
  // turn debug info on
  SupportsDebugInformation = true;
  //HasDotLocAndDotFile = true; -no longer in llvm30
  //HasDotTypeDotSizeDirective = true; -no effect observed
  // decoration for global symbols
  GlobalPrefix = "$";
  PrivateGlobalPrefix = "$";
  //(this would cause some labels to be printed twice)
  //LinkerPrivateGlobalPrefix = "$";
  // new on 3.0 (I think)
  PointerSize = 4;
  IsLittleEndian = 0;
  StackGrowsUp = false; //todo
}
