/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#ifndef CODASIPGENREGISTERINFO_H
#define CODASIPGENREGISTERINFO_H

#include "Codasip.h"
#include "llvm/Target/TargetRegisterInfo.h"

#define GET_REGINFO_ENUM
#define GET_REGINFO_HEADER
#include "CodasipGenRegisterInfo.inc"

namespace llvm {

  struct CodasipGen2RegisterInfo: public CodasipGenRegisterInfo {
    const TargetInstrInfo &TII;

    CodasipGen2RegisterInfo(const TargetInstrInfo &tii);
    
    const unsigned int* getCalleeSavedRegs(const MachineFunction* MF = 0) const;
  
    BitVector getReservedRegs(const MachineFunction &MF) const;
    
    void eliminateFrameIndex(MachineBasicBlock::iterator II, int SPAdj, RegScavenger *RS = NULL) const;
    
    int getDwarfRegNum(unsigned RegNum, bool isEH) const;

    unsigned getFrameRegister(const MachineFunction &MF) const;

    unsigned getRARegister() const;
    
    void eliminateCallFramePseudoInstr(MachineFunction &MF, MachineBasicBlock &MBB, MachineBasicBlock::iterator MI) const;
    
    const TargetRegisterClass* getPointerRegClass(unsigned Kind) const;
  };
  
}

#endif
