//===- Acc.cpp - Acceleration pass" ---------------===//
//  Author: Robert Barucak
//  Email: xbaruc00@stud.fit.vutbr.cz
//                     The LLVM Compiler Infrastructure
//
//
//===----------------------------------------------------------------------===//
//
// This file implements acceleration pass for EdkDSP architecture compiler chain
//RAVAC- robust automatic vector accelerating compiler
//===----------------------------------------------------------------------===//

#define DEBUG_TYPE "hello"
#define BANKCOUNT 4
#define MEMCOUNT 3
//#define PatternCount 5
#include "llvm/Pass.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Transforms/Utils/FunctionUtils.h"
#include "llvm/ADT/Statistic.h"
#include "llvm/Transforms/Scalar.h"
#include "llvm/Module.h"
#include "llvm/Analysis/LoopPass.h"
#include "llvm/Analysis/ScalarEvolution.h"
#include "llvm/Analysis/AliasAnalysis.h"
#include "llvm/Analysis/LoopInfo.h"
#include "llvm/Analysis/LoopDependenceAnalysis.h"
#include "llvm/Analysis/MemoryDependenceAnalysis.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include "llvm/Support/IRBuilder.h"
#include "llvm/Instruction.h"
#include "llvm/ADT/SmallVector.h"
#include "llvm/ADT/ArrayRef.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include <errno.h>

#include "llvm/LLVMContext.h"
#include <unistd.h>

#include "LoopCorrect.h"
#include "BackendRunner.h"
#include "FwIntegrator.h"
#include "IndvarMod.h"

using namespace llvm;


STATISTIC(LoopCounter, "Counts number of loops in source file");

int G_FWCOUNTER=0;

namespace {
  struct Acc : public LoopPass {
	ScalarEvolution *SE;
	DominatorTree *DT;
	LoopInfo *LI;
	LoopDependenceAnalysis *LDA;
	MemoryDependenceAnalysis *MDA;
  public:

    static char ID; // Pass identification, replacement for typeid
    Acc() : LoopPass(ID) {} //registered LLVM opt pass - acceleration pass for EdkDSP


    enum InstrType{
    	//*****memory mapping
    	bMEMA,
    	bMEMB,
    	bMEMZ,
    	bMEMgen,//generic memory type
    	//*****
    	//*****Operations
    	bSTORE,
    	bADD,
    	bSUB,
    	bMULT,

    	//*****bank modes
    	bankFREE, //
    	bankCTS, //combined target/source memory bank in some operations of EdkDSP
    	bankUNUSED, //some set of banks is not used in particular patterns
    	//**** bank types
    	bankTARGET,
    	bankSOURCE,
    	bankEDGE,

    	//*****load info - used for unique store info as well
    	loadMOD, //modified indvar
    	loadCONST, //constant
    	loadEQ, //equivalent to indvar
    	storeMOD,
    	storeCONST,
    	storeEQ

    };
    //virtual bool runOnModule(Module &M);
    virtual bool runOnLoop(Loop *L, LPPassManager &LPM); //running over loops, constructing binary tree
   // virtual bool runOnFunction(Function &F); //running over loops, constructing binary tree
      virtual void getAnalysisUsage(AnalysisUsage &AU) const {
      AU.addRequired<LoopInfo>();
      AU.addRequired<ScalarEvolution>();
      AU.addRequired<DominatorTree>();
    }

  private: //binary tree construction

      /////////////////////////
      bool IndvarAnalysis(Loop *L);
      void InfoGet(Instruction *I, int type);
      //////////////////////////////////


     /////////////////pattern matching related
     std::string sp;
     std::string FirmCore;
     int stat;
     int PatternCount;
     int Mem[3][4];
     int InfoCount;
     int InfoPoolSize;
     Value *TargetDATA;
     ////////////////////loop info
     Value *IVStartValue;
	 Value *IVExitValue;
	 PHINode *IndVar;
	 Instruction *IVIncrement;
	 int TripCount;

	 //////////////help
	 std::string f_name;
  };

}

char Acc::ID = 0;
std::vector<BasicBlock*> ForbidenBlocks; /**< Already processed loops */


static RegisterPass<Acc> X("acc", "acc pass, loop analysis");

/**
 * runOnLoop - Run down all loops in the CFG (recursively, but we could do
 * it in any convenient order), analyzing loop (replace operations with arbiter calls
 * @param *L pointer to loop from passmanager
 * @param &LPM current runing pass manager
 * @return bool If loop was altered true, if not, false
 **/
bool Acc::runOnLoop(Loop *L,LPPassManager &LPM){

    errs()<<"\n\n\n\n++++++++++++++++++++++++++++++++++++++++++XZ\n";
for(llvm::Loop::block_iterator Bit=L->block_begin(), Bitend = L->block_end();Bit!=Bitend;Bit++){
		errs()<<**Bit;
	}
	SE = &getAnalysis<ScalarEvolution>();
	DT = &getAnalysis<DominatorTree>();
    LoopCorrect *Checker= new LoopCorrect( L,L->block_begin(),ForbidenBlocks);
	if(!Checker->IsLoopCorrect(&IVStartValue, &IVExitValue, &IndVar,&TripCount)){
		 errs()<<"+++++++++++++++++++++++++++++++++++++Y\n\n\n";
		return false;
	}
	Checker->ParentDrop(LPM);
	++LoopCounter;

    //extraction of loop, preparing input file for llvm backend
    Function *NewL = llvm::ExtractLoop(*DT,L,0);
    //LPM.deleteLoopFromQueue(L);
errs()<<*NewL;
    IndvarMod *Info=new IndvarMod(L,TripCount,IndVar);
    Info->IndvarAnalysis();
    BackendRunner *Runner = new BackendRunner(NewL,TripCount);

    std::string FwName=Runner->BackendAnalysis(LoopCounter);
    if(FwName!=""){
    	//backend was succesfully generated, generate call system, replace original loop
    	SE->forgetLoop(L);
        //LPM.deleteLoopFromQueue(L);
        FwIntegrator *Builder= new FwIntegrator(L,FwName,G_FWCOUNTER,Info);
        G_FWCOUNTER= Builder->Integrate(&ForbidenBlocks); //run integration of generated firmware
    	//CodeGenerator(L);

    	LPM.deleteLoopFromQueue(L);

    }
   errs()<<"+++++++++++++++++++++++++++++++++++++Y\n\n\n";
    return true;

}


///////////////////////////////////////////////////////////////////////////////////////////////







