/*
 * LoopCorrect.h
 *
 *  Created on: 29.2.2012
 *  Author: Robert Barucak
 *  Email: xbaruc00@stud.fit.vutbr.cz
 */

#ifndef LOOPCORRECT_H_
#define LOOPCORRECT_H_
#include "llvm/Pass.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/Transforms/Utils/BasicBlockUtils.h"
#include "llvm/Transforms/Utils/FunctionUtils.h"
#include "llvm/ADT/Statistic.h"
#include "llvm/Transforms/Scalar.h"
#include "llvm/Module.h"
#include "llvm/Analysis/LoopPass.h"
#include "llvm/Analysis/ScalarEvolution.h"
#include "llvm/Analysis/AliasAnalysis.h"
#include "llvm/Analysis/LoopInfo.h"
#include "llvm/Analysis/LoopDependenceAnalysis.h"
#include "llvm/Analysis/MemoryDependenceAnalysis.h"
#include "llvm/Transforms/Utils/Cloning.h"
#include "llvm/Support/IRBuilder.h"
#include "llvm/Instruction.h"
#include "llvm/ADT/SmallVector.h"
#include "llvm/ADT/ArrayRef.h"
#include <iostream>
#include <fstream>
#include <sstream>
#include <errno.h>

#include "llvm/LLVMContext.h"
#include <unistd.h>

namespace llvm {

class LoopCorrect {
public:
	//loop checking will take place over loop given in constructor
	LoopCorrect(Loop *nL, Loop::block_iterator nLit,std::vector<BasicBlock*> nForbidenBlocks);

	/*
	 *Warious checks of input loop - subloop-free, simplify form, canonical exiting blocks- all mandatory checks
	 *Loop L - input loop
	 */
	bool IsLoopCorrect(Value **IVStartValue, Value **IVExitValue, PHINode **IndVar,int *TripCount);
	virtual ~LoopCorrect();

    void ParentDrop(LPPassManager &LPM);
private:
	Loop *L;
	Loop::block_iterator Lit;
	std::vector<BasicBlock*> ForbidenBlocks;
	/*
	 *If function around loop is only a minimal wrapper (exit block, input block and loop itself) it is dangerous to extract it-
	 *Loop L - input loop
	 */
	bool IsMinimalWrapper();

	/*Input basic block(entire loop) needs to be checked, for any previous changes by acceleration pass
	 * passmanager can call acceleration on loop which is no longer there
	 * Loop::block_iterator Lit - blocks of input loop
	 * Loop L - input loop
	 */
	bool InputBlockCorrect();

	void RParentDropper(Loop *Dropped,LPPassManager &LPM);

};

}

#endif /* LOOPCORRECT_H_ */
