///////////////////////////////////////////////////////////////-*-C-*-
//
// Copyright (c) 2010 Xilinx, Inc.  All rights reserved.
//
// Xilinx, Inc.  XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION
// "AS IS" AS  A COURTESY TO YOU.  BY PROVIDING  THIS DESIGN, CODE, OR
// INFORMATION  AS  ONE   POSSIBLE  IMPLEMENTATION  OF  THIS  FEATURE,
// APPLICATION OR  STANDARD, XILINX  IS MAKING NO  REPRESENTATION THAT
// THIS IMPLEMENTATION  IS FREE FROM  ANY CLAIMS OF  INFRINGEMENT, AND
// YOU ARE  RESPONSIBLE FOR OBTAINING  ANY RIGHTS YOU MAY  REQUIRE FOR
// YOUR  IMPLEMENTATION.   XILINX  EXPRESSLY  DISCLAIMS  ANY  WARRANTY
// WHATSOEVER  WITH RESPECT  TO  THE ADEQUACY  OF THE  IMPLEMENTATION,
// INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR REPRESENTATIONS THAT
// THIS IMPLEMENTATION  IS FREE  FROM CLAIMS OF  INFRINGEMENT, IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// 
//////////////////////////////////////////////////////////////////////

#ifndef __XL_BCE_FP01_1X1_PLBW_H__
#define __XL_BCE_FP01_1X1_PLBW_H__

#include "xbasic_types.h"
#include "xstatus.h"
#include "xcope.h"

typedef struct {
    uint32_t version;
    // Pointers to low-level functions
    xc_status_t (*xc_create)(xc_iface_t **, void *);
    xc_status_t (*xc_release)(xc_iface_t **);
    xc_status_t (*xc_open)(xc_iface_t *);
    xc_status_t (*xc_close)(xc_iface_t *);
    xc_status_t (*xc_read)(xc_iface_t *, xc_r_addr_t, uint32_t *);
    xc_status_t (*xc_write)(xc_iface_t *, xc_w_addr_t, const uint32_t);
    xc_status_t (*xc_get_shmem)(xc_iface_t *, const char *, void **shmem);
    // Optional parameters
    // (empty)
    // Memory map information
    uint32_t z1;
    // uint32_t z1_grant;
    // uint32_t z1_req;
    uint32_t z1_n_bits;
    uint32_t z1_bin_pt;
    uint32_t z1_depth;
    // uint32_t z1_attr;
    uint32_t b1;
    // uint32_t b1_grant;
    // uint32_t b1_req;
    uint32_t b1_n_bits;
    uint32_t b1_bin_pt;
    uint32_t b1_depth;
    // uint32_t b1_attr;
    uint32_t a1;
    // uint32_t a1_grant;
    // uint32_t a1_req;
    uint32_t a1_n_bits;
    uint32_t a1_bin_pt;
    uint32_t a1_depth;
    // uint32_t a1_attr;
    uint32_t pb2mb;
    // uint32_t pb2mb_grant;
    // uint32_t pb2mb_req;
    uint32_t pb2mb_n_bits;
    uint32_t pb2mb_bin_pt;
    uint32_t pb2mb_depth;
    // uint32_t pb2mb_attr;
    uint32_t p1;
    // uint32_t p1_grant;
    // uint32_t p1_req;
    uint32_t p1_n_bits;
    uint32_t p1_bin_pt;
    uint32_t p1_depth;
    // uint32_t p1_attr;
    uint32_t p0;
    // uint32_t p0_grant;
    // uint32_t p0_req;
    uint32_t p0_n_bits;
    uint32_t p0_bin_pt;
    uint32_t p0_depth;
    // uint32_t p0_attr;
    uint32_t mb2pb;
    // uint32_t mb2pb_grant;
    // uint32_t mb2pb_req;
    uint32_t mb2pb_n_bits;
    uint32_t mb2pb_bin_pt;
    uint32_t mb2pb_depth;
    // uint32_t mb2pb_attr;
    // XPS parameters
    Xuint16  DeviceId;
    uint32_t  BaseAddr;
} BCE_FP01_1X1_PLBW_Config;

extern BCE_FP01_1X1_PLBW_Config BCE_FP01_1X1_PLBW_ConfigTable[];

// forward declaration of low-level functions
xc_status_t xc_bce_fp01_1x1_plbw_create(xc_iface_t **iface, void *config_table);
xc_status_t xc_bce_fp01_1x1_plbw_release(xc_iface_t **iface) ;
xc_status_t xc_bce_fp01_1x1_plbw_open(xc_iface_t *iface);
xc_status_t xc_bce_fp01_1x1_plbw_close(xc_iface_t *iface);
xc_status_t xc_bce_fp01_1x1_plbw_read(xc_iface_t *iface, xc_r_addr_t addr, uint32_t *value);
xc_status_t xc_bce_fp01_1x1_plbw_write(xc_iface_t *iface, xc_w_addr_t addr, const uint32_t value);
xc_status_t xc_bce_fp01_1x1_plbw_getshmem(xc_iface_t *iface, const char *name, void **shmem);

#endif

