#ifndef _WAL_BCE_DMA_HEADER_FILE_
#define _WAL_BCE_DMA_HEADER_FILE_

#include <xbasic_types.h>
#include "wal_bce_jsy.h"

/**D
 * enum wal_dma_start_modes - flags to configure DMA transfer between a DDR memory and a worker's data memory
 * @WAL_DMA_REQ_WR: DMA will transfer data from a worker to the DDR memory
 * @WAL_DMA_REQ_RD: DMA will transfer data from the DDR memory to worker's data memory
 * @WAL_DMA_REQ_STRUPDATE: starting DDR address in DMA channel configuration will be automatically updated after transfer
 * @WAL_DMA_REQ_BRAMUPDATE: starting address of worker's data memory in DMA channel configuration will be automatically updated after DMA transfer
 */
/*enum wal_dma_start_modes {
	WAL_DMA_REQ_WR,
	WAL_DMA_REQ_RD,
	WAL_DMA_REQ_STRUPDATE,
	WAL_DMA_REQ_BRAMUPDATE,
}*/
#define WAL_DMA_MAX_CHANNELS     8
#define WAL_DMA_REQ_WR         0x0
#define WAL_DMA_REQ_RD         0x1
#define WAL_DMA_REQ_IRQ        0x2
#define WAL_DMA_REQ_STRUPDATE  0x4
#define WAL_DMA_REQ_BRAMUPDATE 0x8

extern const struct wal_family_desc wal_BCE_DMA_GENERIC_4D_description_structure;

#define WAL_BCE_DMA_GENERIC_4D_MAX_SIMD             WAL_BCE_JSY_MAX_SIMD
#define WAL_BCE_DMA_GENERIC_4D_DMEM_NUM_MEMORIES    WAL_BCE_JSY_GENERIC_4D_SMEM_NUM_MEMORIES
#define WAL_BCE_DMA_GENERIC_4D_CMEM_NUM_MEMORIES    WAL_BCE_JSY_GENERIC_4D_CMEM_NUM_MEMORIES
#define WAL_BCE_DMA_GENERIC_4D_SMEM_NUM_MEMORIES    WAL_BCE_JSY_SMEM_NUM_MEMORIES

/**D
 * wal_dma_configure - Configure DMA channel to transfer data between DDR and worker's data memory
 * @wrk: pointer to the worker structure
 * @channel: index of DMA channel (it can be from range 0-%WAL_DMA_MAX_CHANNELS; %WAL_DMA_MAX_CHANNELS depends on implementation in hardware)
 * @ddraddr: Address of a block of data in DDR. The address must be aligned to 64bit. It addresses byte.
 * @simdidx: Index of SIMD unit in worker (the first SIMD unit has index 0)
 * @bramidx: Index of data memory. Indices of data memories are usually defined in specific header files, e.g. %WAL_BCE_JSY_DMEM_x in wal_bce_jsy.h.
 * @bramaddr: Address into worker's data memory. It addresses words (32bit words for worker with single FP data path)
 * @len: Number of words (32bit for single FP worker) to transfer.
 * 
 * The function configures DMA controller to transfer data between DDR memory and worker's data memory. 
 * The function doesn't start the transfer. It starts with function %wal_dma_start and this function also
 * select direction of the transfer.
 * 
 * Return Value: The function returns zero if successful and a negative value if eny error occurs.
 */
int wal_dma_configure(struct wal_worker *wrk, uint8_t channel, void *ddraddr, unsigned int simdidx, unsigned int bramidx, unsigned int bramaddr, uint16_t len);
/**D
 * wal_dma_start - Start DMA transfer for selected worker and DMA channel
 * @wrk: pointer to the worker structure
 * @channel: index of DMA channel
 * @mode: mode of transfer. ORed flags from %wal_dma_start_modes
 * 
 * The function starts DMA transfer. This function finishs immediately (it isn't blocking).
 * The selected %channel for the worker %wrk must be configured with function %wal_dma_configure before.
 * 
 * Return Value: The function returns zero if successful.
 */
int wal_dma_start(struct wal_worker *wrk, uint8_t channel, uint8_t mode);
/**D
 * wal_dma_isbusy - Read state of DMA channels
 * @wrk: pointer to the worker structure
 * @chmask: bitmap of channels which will be checked
 * 
 * The function checks required DMA channels of worker %wrk. The %chmask selects which channels will be checked.
 * Each bit in chmask is for one DMA channels and bit index in chmask corresponds index of DMA channel (b0 is for channel 0, b1 for channel 1, ...).
 * The function reads actual state and returns immediately.
 * 
 * Return Value: The function returns bitmap of busy channels. Zero bits for channels which weren't checked or isn't busy, ones for channels which are busy.
 */
uint8_t wal_dma_isbusy(struct wal_worker *wrk, uint8_t chmask);


#endif /* _WAL_BCE_DMA_HEADER_FILE_ */
