/* include library for FP01 DFU */
#include "api/10-pb-firmware/pbbcelib.h"
/* MMULT operation has a new ID in accelerator */
#define DFU_OP_MMULT_SET   0x80 /* set parameters of MMULT computation */
#define DFU_OP_TRIG   0x82 /* compute MMULT in higher parts of memories */
#define DFU_OP_TEST 0x83
void main()
{
  unsigned char op, result=0xff;
  unsigned char m=0,n=0,p=0;
  pb2mb_report_running();
        while(1) {
                op = mbpb_exchange_data(0);
                result=0xff;
                if (op==WAL_OP_GETID) {
                        write_bce_id_to_cmem(WAL_BCE_JSY_ID_GENERIC_4D);
                        result = 0;
                } else if (op==WAL_OP_GETCAP) {
                        write_dfu_caps_to_cmem();
                        result = 0;
                } else if (op==WAL_OP_GETLIC) {
                        result = get_dfulic();
                } else if (op==DFU_OP_TRIG) { 

                
                
                pb2dfu_set_cnt(250);
                pb2dfu_set_inc(DFUAG_0, 1);
                pb2dfu_set_inc(DFUAG_1, 1);
                pb2dfu_set_inc(DFUAG_2, 1);
                pb2dfu_set_inc(DFUAG_3, 1);
                pb2dfu_set_fulladdr(DFUAG_0,MBANK_B, 0);
                pb2dfu_set_fulladdr(DFUAG_3,MBANK_C, 0);
                pb2dfu_set_fulladdr(DFUAG_1,MBANK_B, 0);
                pb2dfu_set_fulladdr(DFUAG_2,MBANK_B, 0xff);
                pb2dfu_restart_op(DFU_VMAC);
                pb2dfu_wait4hw();
                  result=0x20;
                } else if (op==DFU_OP_TEST){
                    int i=0;
                    for(i=0;i<10000;i++)
                      mbpb_exchange_data(120);
                }

                mbpb_exchange_data(result);
        }
        return 0;
} 
