/* Provide Declarations */
#include <stdarg.h>
#include <setjmp.h>
#include <limits.h>
/* get a declaration for alloca */
#if defined(__CYGWIN__) || defined(__MINGW32__)
#define  alloca(x) __builtin_alloca((x))
#define _alloca(x) __builtin_alloca((x))
#elif defined(__APPLE__)
extern void *__builtin_alloca(unsigned long);
#define alloca(x) __builtin_alloca(x)
#define longjmp _longjmp
#define setjmp _setjmp
#elif defined(__sun__)
#if defined(__sparcv9)
extern void *__builtin_alloca(unsigned long);
#else
extern void *__builtin_alloca(unsigned int);
#endif
#define alloca(x) __builtin_alloca(x)
#elif defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__DragonFly__) || defined(__arm__)
#define alloca(x) __builtin_alloca(x)
#elif defined(_MSC_VER)
#define inline _inline
#define alloca(x) _alloca(x)
#else
#include <alloca.h>
#endif

#ifndef __GNUC__  /* Can only support "linkonce" vars with GCC */
#define __attribute__(X)
#endif

#if defined(__GNUC__) && defined(__APPLE_CC__)
#define __EXTERNAL_WEAK__ __attribute__((weak_import))
#elif defined(__GNUC__)
#define __EXTERNAL_WEAK__ __attribute__((weak))
#else
#define __EXTERNAL_WEAK__
#endif

#if defined(__GNUC__) && defined(__APPLE_CC__)
#define __ATTRIBUTE_WEAK__
#elif defined(__GNUC__)
#define __ATTRIBUTE_WEAK__ __attribute__((weak))
#else
#define __ATTRIBUTE_WEAK__
#endif

#if defined(__GNUC__)
#define __HIDDEN__ __attribute__((visibility("hidden")))
#endif

#ifdef __GNUC__
#define LLVM_NAN(NanStr)   __builtin_nan(NanStr)   /* Double */
#define LLVM_NANF(NanStr)  __builtin_nanf(NanStr)  /* Float */
#define LLVM_NANS(NanStr)  __builtin_nans(NanStr)  /* Double */
#define LLVM_NANSF(NanStr) __builtin_nansf(NanStr) /* Float */
#define LLVM_INF           __builtin_inf()         /* Double */
#define LLVM_INFF          __builtin_inff()        /* Float */
#define LLVM_PREFETCH(addr,rw,locality) __builtin_prefetch(addr,rw,locality)
#define __ATTRIBUTE_CTOR__ __attribute__((constructor))
#define __ATTRIBUTE_DTOR__ __attribute__((destructor))
#define LLVM_ASM           __asm__
#else
#define LLVM_NAN(NanStr)   ((double)0.0)           /* Double */
#define LLVM_NANF(NanStr)  0.0F                    /* Float */
#define LLVM_NANS(NanStr)  ((double)0.0)           /* Double */
#define LLVM_NANSF(NanStr) 0.0F                    /* Float */
#define LLVM_INF           ((double)0.0)           /* Double */
#define LLVM_INFF          0.0F                    /* Float */
#define LLVM_PREFETCH(addr,rw,locality)            /* PREFETCH */
#define __ATTRIBUTE_CTOR__
#define __ATTRIBUTE_DTOR__
#define LLVM_ASM(X)
#endif

#if __GNUC__ < 4 /* Old GCC's, or compilers not GCC */ 
#define __builtin_stack_save() 0   /* not implemented */
#define __builtin_stack_restore(X) /* noop */
#endif

#if __GNUC__ && __LP64__ /* 128-bit integer types */
typedef int __attribute__((mode(TI))) llvmInt128;
typedef unsigned __attribute__((mode(TI))) llvmUInt128;
#endif

#define CODE_FOR_MAIN() /* Any target-specific code for main()*/

#ifndef __cplusplus
typedef unsigned char bool;
#endif


/* Support for floating point constants */
typedef unsigned long long ConstantDoubleTy;
typedef unsigned int        ConstantFloatTy;
typedef struct { unsigned long long f1; unsigned short f2; unsigned short pad[3]; } ConstantFP80Ty;
typedef struct { unsigned long long f1; unsigned long long f2; } ConstantFP128Ty;


/* Global Declarations */
/* Helper union for bitcasts */
typedef union {
  unsigned int Int32;
  unsigned long long Int64;
  float Float;
  double Double;
} llvmBitCastUnion;

/* Function Declarations */
double fmod(double, double);
float fmodf(float, float);
long double fmodl(long double, long double);
void dummy_call(void);
void fw_data_get(unsigned int , unsigned int , unsigned int , unsigned int , float *, unsigned int , unsigned int , unsigned int );
unsigned int fw_init_fw(unsigned int );
void fw_data_init(unsigned int , unsigned int , unsigned int , unsigned int , float *, unsigned int , unsigned int , unsigned int , float );
void fw_op_start(unsigned int );
void fw_init_table(void);
float bar(float llvm_cbe_c);
float foo(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b);
void foo2(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b);
float foo_bar(float *llvm_cbe_b, float *llvm_cbe_a, float *llvm_cbe_c);
void compute(float *llvm_cbe_a, float *llvm_cbe_b, float *llvm_cbe_c, unsigned int llvm_cbe_decide);
unsigned int main(void);
static void foo_(float *llvm_cbe_a, float *llvm_cbe_c, float *llvm_cbe_b);
static void foo2_(float *llvm_cbe_b, float *llvm_cbe_c, float *llvm_cbe_a);
static void foo_bar_(float *llvm_cbe_a, float *llvm_cbe_c, float *llvm_cbe_b);
static void main_(float *, float *, float *);
static void main_1(float (*llvm_cbe_c)[256], float (*llvm_cbe_b)[256], float (*llvm_cbe_a)[256]);
void abort(void);


/* Function Bodies */
static inline int llvm_fcmp_ord(double X, double Y) { return X == X && Y == Y; }
static inline int llvm_fcmp_uno(double X, double Y) { return X != X || Y != Y; }
static inline int llvm_fcmp_ueq(double X, double Y) { return X == Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_une(double X, double Y) { return X != Y; }
static inline int llvm_fcmp_ult(double X, double Y) { return X <  Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_ugt(double X, double Y) { return X >  Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_ule(double X, double Y) { return X <= Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_uge(double X, double Y) { return X >= Y || llvm_fcmp_uno(X, Y); }
static inline int llvm_fcmp_oeq(double X, double Y) { return X == Y ; }
static inline int llvm_fcmp_one(double X, double Y) { return X != Y && llvm_fcmp_ord(X, Y); }
static inline int llvm_fcmp_olt(double X, double Y) { return X <  Y ; }
static inline int llvm_fcmp_ogt(double X, double Y) { return X >  Y ; }
static inline int llvm_fcmp_ole(double X, double Y) { return X <= Y ; }
static inline int llvm_fcmp_oge(double X, double Y) { return X >= Y ; }

void dummy_call(void) {
  unsigned int llvm_cbe_tmp__1;

  fw_data_get(0u, 0u, 0u, 0u, ((float *)/*NULL*/0), 0u, 0u, 0u);
  llvm_cbe_tmp__1 = fw_init_fw(0u);
  fw_data_init(0u, 0u, 0u, 0u, ((float *)/*NULL*/0), llvm_cbe_tmp__1, llvm_cbe_tmp__1, 0u, 0x0p+0);
  fw_op_start(0u);
  fw_init_table();
  return;
}


float bar(float llvm_cbe_c) {
  return (((float )(llvm_cbe_c * llvm_cbe_c)));
}


float foo(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b) {
  float *llvm_cbe_tmp__2;
  float llvm_cbe_tmp__3;
  float llvm_cbe_tmp__4;

  foo_(llvm_cbe_a, llvm_cbe_c, llvm_cbe_b);
  llvm_cbe_tmp__2 = (&llvm_cbe_b[((signed int )3u)]);
  llvm_cbe_tmp__3 = *llvm_cbe_tmp__2;
  *((&llvm_cbe_b[((signed int )5u)])) = llvm_cbe_tmp__3;
  llvm_cbe_tmp__4 = *llvm_cbe_tmp__2;
  return llvm_cbe_tmp__4;
}


void foo2(float *llvm_cbe_c, float *llvm_cbe_a, float *llvm_cbe_b) {
  float llvm_cbe_tmp__5;

  foo2_(llvm_cbe_b, llvm_cbe_c, llvm_cbe_a);
  llvm_cbe_tmp__5 = *((&llvm_cbe_b[((signed int )2u)]));
  *((&llvm_cbe_b[((signed int )5u)])) = llvm_cbe_tmp__5;
  return;
}


float foo_bar(float *llvm_cbe_b, float *llvm_cbe_a, float *llvm_cbe_c) {
  float llvm_cbe_tmp__6;

  foo_bar_(llvm_cbe_a, llvm_cbe_c, llvm_cbe_b);
  llvm_cbe_tmp__6 = *((&llvm_cbe_a[((signed int )6u)]));
  *((&llvm_cbe_b[((signed int )3u)])) = llvm_cbe_tmp__6;
  return llvm_cbe_tmp__6;
}


void compute(float *llvm_cbe_a, float *llvm_cbe_b, float *llvm_cbe_c, unsigned int llvm_cbe_decide) {
  float llvm_cbe_tmp__7;

  if ((llvm_cbe_decide == 0u)) {
    goto llvm_cbe_tmp__8;
  } else {
    goto llvm_cbe_tmp__9;
  }

llvm_cbe_tmp__9:
  llvm_cbe_tmp__7 =  /*tail*/ foo(llvm_cbe_c, llvm_cbe_a, llvm_cbe_b);
  goto llvm_cbe_tmp__10;

llvm_cbe_tmp__8:
   /*tail*/ foo2(llvm_cbe_b, llvm_cbe_a, llvm_cbe_c);
  goto llvm_cbe_tmp__10;

llvm_cbe_tmp__10:
  return;
}


unsigned int main(void) {
  float llvm_cbe_a[256];    /* Address-exposed local */
  float llvm_cbe_b[256];    /* Address-exposed local */
  float llvm_cbe_c[256];    /* Address-exposed local */

  CODE_FOR_MAIN();
  main_1((&llvm_cbe_c), (&llvm_cbe_b), (&llvm_cbe_a));
  main_((((float *)(unsigned long)((((unsigned int )(unsigned long)((&llvm_cbe_a[((signed int )1u)])))) & 4294967288u))), (((float *)(unsigned long)((((unsigned int )(unsigned long)((&llvm_cbe_b[((signed int )1u)])))) & 4294967288u))), (((float *)(unsigned long)((((unsigned int )(unsigned long)((&llvm_cbe_c[((signed int )1u)])))) & 4294967288u))));
  return 0u;
}


static void foo_(float *llvm_cbe_a, float *llvm_cbe_c, float *llvm_cbe_b) {
  unsigned int llvm_cbe_wrk_id;

  fw_init_table();
  llvm_cbe_wrk_id = fw_init_fw(0u);
  fw_data_init(llvm_cbe_wrk_id, 0u, 1u, 1u, llvm_cbe_b, 0u, 0u, 250u, 0x0p+0);
  fw_data_init(llvm_cbe_wrk_id, 255u, 1u, 1u, llvm_cbe_c, 0u, 0u, 250u, 0x0p+0);
  fw_data_init(llvm_cbe_wrk_id, 0u, 2u, 1u, llvm_cbe_a, 0u, 0u, 250u, 0x0p+0);
  fw_op_start(llvm_cbe_wrk_id);
  fw_data_get(llvm_cbe_wrk_id, 0u, 1u, 1u, llvm_cbe_a, 0u, 0u, 250u);
  return;
}


static void foo2_(float *llvm_cbe_b, float *llvm_cbe_c, float *llvm_cbe_a) {
  unsigned int llvm_cbe_wrk_id;

  fw_init_table();
  llvm_cbe_wrk_id = fw_init_fw(1u);
  fw_data_init(llvm_cbe_wrk_id, 0u, 1u, 1u, llvm_cbe_a, 0u, 0u, 250u, 0x0p+0);
  fw_data_init(llvm_cbe_wrk_id, 255u, 1u, 1u, llvm_cbe_c, 0u, 0u, 250u, 0x0p+0);
  fw_data_init(llvm_cbe_wrk_id, 0u, 2u, 1u, llvm_cbe_b, 0u, 0u, 250u, 0x0p+0);
  fw_op_start(llvm_cbe_wrk_id);
  fw_data_get(llvm_cbe_wrk_id, 0u, 1u, 1u, llvm_cbe_b, 0u, 0u, 250u);
  return;
}


static void foo_bar_(float *llvm_cbe_a, float *llvm_cbe_c, float *llvm_cbe_b) {
  unsigned int llvm_cbe_wrk_id;

  fw_init_table();
  llvm_cbe_wrk_id = fw_init_fw(2u);
  fw_data_init(llvm_cbe_wrk_id, 0u, 1u, 1u, llvm_cbe_b, 0u, 0u, 250u, 0x0p+0);
  fw_data_init(llvm_cbe_wrk_id, 255u, 1u, 2u, llvm_cbe_c, 2u, 0u, 250u, 0x0p+0);
  fw_op_start(llvm_cbe_wrk_id);
  fw_data_get(llvm_cbe_wrk_id, 0u, 1u, 2u, llvm_cbe_a, 2u, 0u, 250u);
  return;
}


static void main_(float *llvm_cbe_tmp__11, float *llvm_cbe_tmp__12, float *llvm_cbe_tmp__13) {
  unsigned int llvm_cbe_i_2e_11;
  unsigned int llvm_cbe_i_2e_11__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp__14;

  llvm_cbe_i_2e_11__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__15;

llvm_cbe__2e_exitStub:
  return;
  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__15:
  llvm_cbe_i_2e_11 = llvm_cbe_i_2e_11__PHI_TEMPORARY;
  compute(llvm_cbe_tmp__11, llvm_cbe_tmp__12, llvm_cbe_tmp__13, 0u);
  llvm_cbe_tmp__14 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_11) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__14 == 10000u)) {
    goto llvm_cbe__2e_exitStub;
  } else {
    llvm_cbe_i_2e_11__PHI_TEMPORARY = llvm_cbe_tmp__14;   /* for PHI node */
    goto llvm_cbe_tmp__15;
  }

  } while (1); /* end of syntactic loop '' */
}


static void main_1(float (*llvm_cbe_c)[256], float (*llvm_cbe_b)[256], float (*llvm_cbe_a)[256]) {
  unsigned int llvm_cbe_i_2e_02;
  unsigned int llvm_cbe_i_2e_02__PHI_TEMPORARY;
  unsigned int llvm_cbe_tmp__16;

  llvm_cbe_i_2e_02__PHI_TEMPORARY = 0u;   /* for PHI node */
  goto llvm_cbe_tmp__17;

llvm_cbe__2e_exitStub:
  return;
  do {     /* Syntactic loop '' to make GCC happy */
llvm_cbe_tmp__17:
  llvm_cbe_i_2e_02 = llvm_cbe_i_2e_02__PHI_TEMPORARY;
  *((&(*llvm_cbe_a)[((signed int )llvm_cbe_i_2e_02)])) = 0x1.4p+3;
  *((&(*llvm_cbe_b)[((signed int )llvm_cbe_i_2e_02)])) = 0x1p+1;
  *((&(*llvm_cbe_c)[((signed int )llvm_cbe_i_2e_02)])) = 0x1p+0;
  llvm_cbe_tmp__16 = ((unsigned int )(((unsigned int )llvm_cbe_i_2e_02) + ((unsigned int )1u)));
  if ((llvm_cbe_tmp__16 == 256u)) {
    goto llvm_cbe__2e_exitStub;
  } else {
    llvm_cbe_i_2e_02__PHI_TEMPORARY = llvm_cbe_tmp__16;   /* for PHI node */
    goto llvm_cbe_tmp__17;
  }

  } while (1); /* end of syntactic loop '' */
}

