#include "fw_incl.h"
#include "manager.h"
//#include <wal.h>
//#include <wal_bce_jk.h>
/* include WAL - worker abstraction layer */
#include "../api/12-mb-petalinux/libwal/wal.h"
#include "../api/12-mb-petalinux/libwal/wal_bce_dma.h"
/* include description of hardware IP core BCE worker */
#include "../api/12-mb-petalinux/libbce_config_step5/bce_dma_config.h"

//#include "bce_fp01_1x1_plbw.h"
#include <pthread.h>

//#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <unistd.h>
#include <pthread.h>

#define MMULT_TRIG 0x82 
// operation code, which is being send to worker unit upon start of operation

typedef struct table{
  wal_worker_t *wrk;
  unsigned int state;
  int fw0;
  int fw1;
}table_entry;

#define WORKER_COUNT 10
unsigned int table_trigger=0;
table_entry worker_table[WORKER_COUNT]; //table for accesing worker data structures
const unsigned int *fw[20]; //table of firmwares

WAL_REGISTER_WORKER(worker, BCE_DMA_GENERIC_4D, bce_dma_cfgtable, 0, 1, 0);
WAL_REGISTER_WORKER(worker2, BCE_DMA_GENERIC_4D, bce_dma_cfgtable, 1, 1, 0);
////////////////////////

/*function to initialize data to in worker
 * wrk_index -ID of worker
 * xh -id of mem bank
 * x_inc -increment rate
 * *x_data -pointer to data
 * xNN -trip coun
 * mem -index of memory bank
 * const- conastant value
 */
void fw_data_init(unsigned int wrk_index,unsigned int xh, unsigned int mem,unsigned int x_inc,float *x_data,unsigned int add_mod,unsigned int mult_mod, unsigned int xNN,  float constant){
  signed int mult_mod_x=(signed)mult_mod;
  signed int add_mod_x=(signed)add_mod;
  unsigned int bank=0;
  if(mem==0){
    bank=WAL_BCE_JSY_DMEM_A;
  }else if(mem==1){
    bank=WAL_BCE_JSY_DMEM_B;
  }else if(mem==2){
    bank=WAL_BCE_JSY_DMEM_C;
  }else if(mem==3){
    bank=WAL_BCE_JSY_DMEM_D;
  }
  if(x_inc==4){
    ;;
  }
 // printf("DATA INIT\n");
  
  if(x_inc==0){
    //xNN=1;
    x_data=&constant;
    
  }
  if (wal_dma_configure(worker_table[wrk_index].wrk, 0, &(x_data[add_mod]), 0, bank, xh, xNN*mult_mod)) return; //data
        if (wal_dma_start(worker_table[wrk_index].wrk, 0, WAL_DMA_REQ_RD)) return;
        while (wal_dma_isbusy(worker_table[wrk_index].wrk, (0x01))!=0){
            ;//printf("transfer\n");
        }
}

/* get data from worker after finished operation
 * wrk_index -ID of worker
 * mem -index of memory
 * xh -id of memory bank
 * *x_data -pointer to result store
 * xNN -data count
 */
void fw_data_get(unsigned int wrk_index,unsigned int xh ,unsigned int mem,unsigned int x_inc, float *x_data, unsigned int add_mod, unsigned int mult_mod,unsigned int xNN ){
 if(mem==0){
    mem=WAL_BCE_JSY_DMEM_A;
  }else if(mem==1){
    mem=WAL_BCE_JSY_DMEM_B;
  }else if(mem==2){
    mem=WAL_BCE_JSY_DMEM_C;
  }else if(mem==3){
    mem=WAL_BCE_JSY_DMEM_D;
  }
  unsigned int i;
  //printf("DATA GET\n");
  
  if (wal_dma_configure(worker_table[wrk_index].wrk, 0, &(x_data[add_mod]), 0, mem, xh, xNN*mult_mod)) return; //data
        if (wal_dma_start(worker_table[wrk_index].wrk, 0, WAL_DMA_REQ_WR)) return;
        while (wal_dma_isbusy(worker_table[wrk_index].wrk, (0x01))!=0){
            ;//printf("transfer_back\n");
        }
  worker_table[wrk_index].state=1;
}


/*
 * initializing worker table
 */
void fw_init_table(){
  fw_reg(fw); //register firmwares into fw list
  if(table_trigger!=0){
    return;
  }
  ++table_trigger;
  int i;
  for(i=0;i<WORKER_COUNT;++i){
    if(i==0){
        worker_table[i].wrk=worker;
    }
    if(i==1){
        worker_table[i].wrk=worker2;
    }

    
    worker_table[i].state=1;
    if(i>1){
      worker_table[i].state=0;
 
    }
    worker_table[i].fw0=-1;
    worker_table[i].fw1=-1;
  }
}


/*
 * initialize firmware, find free worker, reserve it
 * fw_id -ID of firmware
 * return -ID of free initialized worker
 */

unsigned int fw_init_fw(unsigned int fw_id){
  
  int i;
 // printf("Init FW\n");
  int wrk_id=-1; //mod needed - check for included firmwares in unused workers
  for(i=0;i<WORKER_COUNT;++i){
    if(worker_table[i].state==1 ){
      worker_table[i].state=0;
      wrk_id=i;
      if(worker_table[i].fw0==fw_id){
	return wrk_id;
      }
      break;
    }
    if(i==WORKER_COUNT){
      i=0;
    }
  }
  if (wal_init_worker(worker_table[wrk_id].wrk)) return -1;
  if (wal_set_firmware(worker_table[wrk_id].wrk, WAL_PBID_P0, fw[fw_id], -1)) return -2;
  if (wal_reset_worker(worker_table[wrk_id].wrk)) return -3;
  //printf("cislo fw:%d\n",fw_id);
  worker_table[wrk_id].fw0=fw_id;
  return wrk_id;
}

/* start operation in worker
 * wrk_index - index of worker
 */
void fw_op_start(unsigned int wrk_index){
  int ret;
  uint32_t get;
 wal_start_operation(worker_table[wrk_index].wrk, WAL_PBID_P0); //start operation
 if (wal_mb2pb(worker_table[wrk_index].wrk, MMULT_TRIG)) return;      //trigger op in firmware
 //printf("start\n");
 while (wal_is_busy(worker_table[wrk_index].wrk)!=0) {  //wait for result
            ;
 }
 ret = wal_pb2mb(worker_table[wrk_index].wrk, &get);
        //printf("ret:%d\n",get);
}

