/**
 * Implementation of TransformPhiInstrToSelect class methods
 * Author:  Tomas Minac <xminac01@stud.fit.vutbr.cz>
 * Date:    16.07.2012
 */

#include "TransformPhiInstrToSelect.h"

using namespace llvm;
using namespace std;

//method for creating new select instruction and eliminate two argument of phi node
void TransformPhiInstrToSelect::createNewInstr(BranchInst *branchInst,BasicBlock* bb, BasicBlock *secondBB, bool firstRight)  {
  vecSelectInst.clear();
  for(unsigned i=0;i<vecPhiNodes.size();++i) {
    PHINode *APN=vecPhiNodes[i];
    unsigned maxId=APN->getNumIncomingValues();
    assert(maxId!=0 && "Phi with zero incoming edge.");
    if(maxId == 2) {
      //simply destroy it and create select on this place
      //first take return values
      Value *first=NULL, *second=NULL, *cond=NULL;
      assert(!branchInst->isUnconditional());
      cond = branchInst->getCondition();
      first = APN->getIncomingValueForBlock(bb);
      second = APN->getIncomingValueForBlock(secondBB);
      assert((cond != NULL || first != NULL   || second !=NULL) && "One of these things can not be NULL."); 
      //create new select instruction
      SelectInst * select;
      if(firstRight) {
        select=SelectInst::Create(cond,second,first);
      }
      else {
        select=SelectInst::Create(cond,first,second);
      }
      BasicBlock::iterator ii(APN);
      //and replace it
      ReplaceInstWithInst(APN->getParent()->getInstList(),ii,select);
      //create simple jump
      /*BranchInst::Create(secondBB,branchInst);
      branchInst->eraseFromParent();*/

      vecSelectInst.push_back(select);
    }
    else {
      assert(maxId > 2 && "Phi with one edge? Little strange.");
      Value *first=NULL, *second=NULL, *cond=NULL;
      assert(!branchInst->isUnconditional());
      cond = branchInst->getCondition();
      first = APN->removeIncomingValue(bb);
      second = APN->removeIncomingValue(secondBB);
      assert((cond != NULL || first != NULL   || second !=NULL) && "One of these things can not be NULL.");
      //create new select instruction
      SelectInst * select;
      if(firstRight) {
        select=SelectInst::Create(cond,second,first);
      }
      else {
        select=SelectInst::Create(cond,first,second);
      }
      BranchInst *termInst= dyn_cast<BranchInst>(secondBB->getTerminator());
      assert(termInst != NULL && "Terminator instruction is NULL? Not to good.");
      //insert new select instruction
      select->insertBefore(termInst);
      //add value to phi node
      APN->addIncoming(select,secondBB);
      //create simple jump
      vecSelectInst.push_back(select);
    }
  }
  BranchInst::Create(secondBB,branchInst);
  branchInst->eraseFromParent();
}

//sum of incomming edge for every basic block
//it save to mapBBtoIncomingEdge
void TransformPhiInstrToSelect::setMapBBtoIncomingEdge(Function *F) {
  mapBBtoIncomingEdge.clear();
  for(Function::iterator iter=F->begin();iter!=F->end();++iter) {
    BasicBlock *bb=iter;
    BranchInst *branchInst = dyn_cast<BranchInst>(bb->getTerminator());
    if(branchInst != NULL) {
      unsigned numbOfChild=bb->getTerminator()->getNumSuccessors();
      for(unsigned i=0;i<numbOfChild;++i) {
        mapBBtoIncomingEdge[bb->getTerminator()->getSuccessor(i)]++;
      }
    }
  }

}

//check if some of basic blocks has successors bb1 and bb0 from ascci picture in TransformPhiInstrToSelect.h
//in this case merging blocks is not allow, because is pattern for CompactShortEvaluation
//special case for rhombus pattern
bool TransformPhiInstrToSelect::checkForMerging(Function *F,BasicBlock*bb0,  BasicBlock *bbF, BasicBlock *bbS) {

  for(Function::iterator iter=F->begin();iter!=F->end();++iter) {
    BasicBlock *bb=iter;
    if(bb0==bb) continue;
    BranchInst *branchInst = dyn_cast<BranchInst>(bb->getTerminator());
    if(branchInst != NULL) {
      if(bb->getTerminator()->getNumSuccessors()==2) {
        BasicBlock* firstBB = bb->getTerminator()->getSuccessor(0);
        BasicBlock* secondBB = bb->getTerminator()->getSuccessor(1);
        if((bbF == firstBB && bbS==secondBB) || (bbF==secondBB && bbS==firstBB)) {
          return true;
        }
      }
    }
  }
  
  return false;
}

//check if some of basic blocks has successors bb1 and bb0 from ascci picture in TransformPhiInstrToSelect.h
//in this case merging blocks is not allow, because is pattern for CompactShortEvaluation
bool TransformPhiInstrToSelect::checkForMerging(Function *F, BasicBlock *bbF, BasicBlock *bbS) {

  for(Function::iterator iter=F->begin();iter!=F->end();++iter) {
    BasicBlock *bb=iter;
    BranchInst *branchInst = dyn_cast<BranchInst>(bb->getTerminator());
    if(branchInst != NULL) {
      if(bb->getTerminator()->getNumSuccessors()==2) {
        BasicBlock* firstBB = bb->getTerminator()->getSuccessor(0);
        BasicBlock* secondBB = bb->getTerminator()->getSuccessor(1);
        if((bbF == firstBB && bbS==secondBB) || (bbF==secondBB && bbS==firstBB)) {
          return true;
        }
      }
    }
  }
  
  return false;
}

/* NOT USE this hacky alg
//if bb1 in ascii picture from TransformPhiInstrToSelect.h has more then one incomming edge, it is necessary
//reconnect every incoming edge to bb0 and change condition in select which one was created, when merging
//was doing.
void TransformPhiInstrToSelect::reConnectAllPredecessor(Function *F, BasicBlock *bb, BasicBlock *firstBB, BasicBlock *brotherBB, bool neg) {
  bool firstTimeFind=true;
  assert(vecSelectInst.size()==vecPhiNodes.size() && "These two vectors have to have same size.");
  for(unsigned i=0;i<vecSelectInst.size();++i) {
    SelectInst *selInstr=vecSelectInst[i];
    //we have to reconnect all predecessor of firstBB to bb
    for(Function::iterator iter=F->begin();iter!=F->end();++iter) {
      BasicBlock *bbIter=iter;
      if(bbIter==bb) continue;
      if(bbIter==brotherBB) continue; //in brotherBB is pointer for another basic block, which one is merging
      BranchInst *branchInst = dyn_cast<BranchInst>(bbIter->getTerminator());
      if(branchInst != NULL) {
        unsigned numbOfChild=branchInst->getNumSuccessors();
        for(unsigned i=0;i<numbOfChild;++i) {
          if(firstBB == branchInst->getSuccessor(i)) {
            cerr<<neg<<" && "<<firstTimeFind<<endl;
            if(neg && firstTimeFind) {
              cerr<<"Treba zmenit podmienku"<<endl;
              firstTimeFind=false;
              assert(false && "IMPLEMENT IT");
            }
            //take branch instruction from it
            branchInst->setSuccessor(i,bb);
            if(i==0) {
              assert(!branchInst->isUnconditional());
              Value* cond = branchInst->getCondition();
              //create negation of condition
              BinaryOperator* notInst = BinaryOperator::CreateNot(cond, "neg", branchInst);
              BinaryOperator* condMergeInst = BinaryOperator::Create(BinaryOperator::And, notInst, selInstr->getCondition(), "combined", selInstr);
              //create new select instruction
              SelectInst *newSelect=SelectInst::Create(condMergeInst,selInstr->getTrueValue(),selInstr->getFalseValue());
              //and replace it
              ReplaceInstWithInst(selInstr,newSelect);
              selInstr=newSelect;
            }
            else if(i==1) {
              //create condition
              assert(!branchInst->isUnconditional());
              BinaryOperator* condMergeInst = BinaryOperator::Create(BinaryOperator::And, branchInst->getCondition(), selInstr->getCondition(), "combined", selInstr);
              //create select
              SelectInst *newSelect=SelectInst::Create(condMergeInst,selInstr->getTrueValue(),selInstr->getFalseValue());
              //and replace it
              ReplaceInstWithInst(selInstr,newSelect);
              selInstr=newSelect;
            }
            else {
              assert(false && "Condition instruction has more then two succesor. Not supported.");
            }
          }
        }
      }
    }
  }
}
*/

//function which take these phi nodes from basic block, which has bb0 and bb1 in arguments
//(from ascii picture in TransformPhiInstrToSelect.h) 
bool TransformPhiInstrToSelect::isPhiNodeInBB(BasicBlock *bb, BasicBlock *firstBB, BasicBlock *secondBB) {
  bool retVal=false;
  
  vecPhiNodes.clear();
  for(BasicBlock::iterator it=bb->begin(); it!=bb->end(); ++it) {
    PHINode * phiInstr=dyn_cast<PHINode>(it);
    if(phiInstr!=NULL) {
      if((phiInstr->getBasicBlockIndex(firstBB)!=-1) && (phiInstr->getBasicBlockIndex(secondBB)!=-1)) {
        vecPhiNodes.push_back(phiInstr);
        retVal=true;
      }
    }
  }

  return retVal;
}


//if we clone basic block. We have to repair all phi node, which old basic block was pointing
void TransformPhiInstrToSelect::repairPhiNode(BasicBlock *origBB, BasicBlock *cloneBB){
  unsigned numOfChild=origBB->getTerminator()->getNumSuccessors();
  for(unsigned i=0;i<numOfChild;++i) {
    BasicBlock *child=origBB->getTerminator()->getSuccessor(i);
    for(BasicBlock::iterator it=child->begin(); it!=child->end(); ++it) {
      PHINode * phiInstr=dyn_cast<PHINode>(it);
      if(phiInstr!=NULL) {
        //take incomming value
        Value* val=phiInstr->getIncomingValueForBlock(origBB);
        if(val!=NULL) {
          //set incomming value with new basic block
          phiInstr->addIncoming(val,cloneBB);
        }
      }
    }
  }
}


//We have to repair some instruction in new clone basic block. We looking for instructions (all in clone BB) which
//operand is value from old basic block. We have to replace it.
void TransformPhiInstrToSelect::repairInstruction(/*ValueMap<const Value*, Value*>*/ ValueToValueMapTy &VMap,BasicBlock *origBB, BasicBlock *cloneBB) {
  for(BasicBlock::iterator iter=cloneBB->begin();iter!=cloneBB->end();++iter) {
    Instruction *origInstr=iter;
    for(unsigned i=0;i<origInstr->getNumOperands();++i) {
      Value * val= origInstr->getOperand(i);
      ValueToValueMapTy::iterator mapIter=VMap.find(val);
      if(mapIter!=VMap.end()) {
        //we find instruction, which has operand from old basic block
        //let replace it
        Value *newVal=mapIter->second;
        assert(newVal != NULL && "Changed when switching from 2.8 to 3.2");
        origInstr->setOperand(i,newVal);
      }
    }
  }
}

//go through basic blocks and try find triangle pattern
/*                      bb0
 *                     /  \
 *                    /    |
 *                   bb1   |
 *                    \    |
 *                     \  /
 *                      bb2 with phi node
 */
bool TransformPhiInstrToSelect::testForTriangle(Function *F) {
  bool retVal=false;
  for(Function::iterator iter=F->begin();iter!=F->end();++iter) {
    BasicBlock *bb=iter;
    BranchInst *branchInst = dyn_cast<BranchInst>(bb->getTerminator());
    if(branchInst != NULL) {
      //ok, we have branch instr
      if(bb->getTerminator()->getNumSuccessors()==2) {
        //take successors
        BasicBlock* firstBB = bb->getTerminator()->getSuccessor(0);
        BasicBlock* secondBB = bb->getTerminator()->getSuccessor(1);

        //errs() << "\nFIRST\n" << *firstBB;
        //errs() << "\nSECOND\n" << *secondBB;

        assert(firstBB!=secondBB && "This is signal for bug.");
        if(firstBB->getTerminator()->getNumSuccessors()==1 && (secondBB->getTerminator()->getNumSuccessors()==2 || secondBB->getTerminator()->getNumSuccessors()==0)) {
           BasicBlock * lookingBB=firstBB->getTerminator()->getSuccessor(0);
           if(lookingBB == secondBB) {
             bool hasPhi=isPhiNodeInBB(lookingBB,bb,firstBB); //take all phi nodes in BB
             assert(mapBBtoIncomingEdge.find(firstBB)!=mapBBtoIncomingEdge.end());
             if (hasPhi && !checkForMerging(F,bb,firstBB) /*&& XXX!bbHasSideEffects(firstBB,F)*/) {
               unsigned tmp=mapBBtoIncomingEdge[firstBB];
               if(tmp>1) {
                 --mapBBtoIncomingEdge[firstBB];
                 //XX32 ValueMap<const Value*, Value*> VMap;
                 ValueToValueMapTy VMap;
                 BasicBlock * cloneBB=CloneBasicBlock(firstBB,VMap,"Clone",F);
                 //if basic block point to BB which contain phi, put it to phi
                 repairPhiNode(firstBB, cloneBB);
                 repairInstruction(VMap, firstBB,cloneBB);
                 //errs()<<*cloneBB<<"\n";
                 firstBB=cloneBB;
               }
               //we find pattern
               //errs()<<"MERGE: "<<firstBB->getNameStr()<<" and "<<bb->getNameStr()<<"\n";
               createNewInstr(branchInst,bb,firstBB,true);
               retVal=true;
             }
           }
        }
        if(secondBB->getTerminator()->getNumSuccessors()==1 && (firstBB->getTerminator()->getNumSuccessors()==2 || firstBB->getTerminator()->getNumSuccessors()==0 || firstBB->getTerminator()->getNumSuccessors()==1)) {
          BasicBlock *lookingBB=secondBB->getTerminator()->getSuccessor(0);
          if(lookingBB==firstBB) {
             bool hasPhi=isPhiNodeInBB(lookingBB,bb,secondBB);
             assert(mapBBtoIncomingEdge.find(secondBB)!=mapBBtoIncomingEdge.end());
             if (hasPhi && !checkForMerging(F,bb,secondBB) /* XXX&& !bbHasSideEffects(secondBB,F)*/) {
               unsigned tmp=mapBBtoIncomingEdge[secondBB];
               if(tmp>1) {
                 --mapBBtoIncomingEdge[secondBB];
                 //ValueMap<const Value*, Value*> VMap;
                 ValueToValueMapTy VMap;
                 BasicBlock * cloneBB=CloneBasicBlock(secondBB,VMap,"Clone",F);
                 repairPhiNode(secondBB, cloneBB);
                 repairInstruction(VMap, secondBB,cloneBB);
                 //errs()<<*cloneBB<<"\n";
                 secondBB=cloneBB;
               }
               //errs()<<"MERGE: "<<secondBB->getNameStr()<<" and "<<bb->getNameStr()<<"\n";
               createNewInstr(branchInst,bb,secondBB,false);
               retVal=true;
               //if(tmp!=1) {
                  //we have to reconnect all predecessor with merging block
               //   reConnectAllPredecessor(F,bb,secondBB,NULL,/*neg*/false);
               //}
             }
          }
        }
        //and special not triangel but rhombus pattern
        /*          bb0
         *         /  \
         *        /    \
         *      bb1    bb2
         *       \      /
         *         \  /
         *         bb3 with phi node
         */
        if(firstBB->getTerminator()->getNumSuccessors()==1 && secondBB->getTerminator()->getNumSuccessors()==1) {
          if(firstBB->getTerminator()->getSuccessor(0) == secondBB->getTerminator()->getSuccessor(0)) {
            BasicBlock *thirdBB=firstBB->getTerminator()->getSuccessor(0);
            bool hasPhi=isPhiNodeInBB(thirdBB,firstBB,secondBB);
            assert(mapBBtoIncomingEdge.find(firstBB)!=mapBBtoIncomingEdge.end());
            assert(mapBBtoIncomingEdge.find(secondBB)!=mapBBtoIncomingEdge.end());
            unsigned tmp1=mapBBtoIncomingEdge[firstBB];
            unsigned tmp2=mapBBtoIncomingEdge[secondBB];
            if(hasPhi && !checkForMerging(F,bb,firstBB) && !checkForMerging(F,bb,secondBB) && !checkForMerging(F,bb,firstBB,secondBB)/*XXX&& !bbHasSideEffects(firstBB,F) && !bbHasSideEffects(secondBB,F)*/) {
              //if basic block which we want to merge has side input, let clone the basic block
              if(tmp1>1) {
                --mapBBtoIncomingEdge[firstBB];
                //ValueMap<const Value*, Value*> VMap;
                ValueToValueMapTy VMap;
                BasicBlock * cloneBB=CloneBasicBlock(firstBB,VMap,"Clone",F);
                repairPhiNode(firstBB,cloneBB);
                repairInstruction(VMap, firstBB,cloneBB);
                firstBB=cloneBB;

              }
              //if basic block which we want to merge has side input, let clone the basic block
              if(tmp2>1) {
                --mapBBtoIncomingEdge[secondBB];
                //ValueMap<const Value*, Value*> VMap;
                ValueToValueMapTy VMap;
                BasicBlock * cloneBB=CloneBasicBlock(secondBB,VMap,"Clone",F);
                repairPhiNode(secondBB,cloneBB);
                repairInstruction(VMap, secondBB,cloneBB);
                secondBB=cloneBB;
              }
              //errs()<<"MERGE: "<<firstBB->getNameStr()<<" and "<<secondBB->getNameStr()<<" and "<<bb->getNameStr()<<"\n";
              //debug print
              createNewInstr(branchInst,firstBB,secondBB,false);
              //some repairing for this one bb0 -> bb1 -> bb2 -> bb3
              BranchInst *bb0Branch=dyn_cast<BranchInst>(bb->getTerminator());
              assert(bb0Branch!=NULL && bb0Branch->isUnconditional());
              bb0Branch->setSuccessor(0,firstBB);
              BranchInst *bb1Branch=dyn_cast<BranchInst>(firstBB->getTerminator());
              assert(bb1Branch!=NULL && bb1Branch->isUnconditional());
              bb1Branch->setSuccessor(0,secondBB);
              BranchInst *bb2Branch=dyn_cast<BranchInst>(secondBB->getTerminator());
              assert(bb2Branch!=NULL && bb2Branch->isUnconditional());
              bb2Branch->setSuccessor(0,thirdBB);
              retVal=true;
            }
          }
        }
      }
    }
  }
  return retVal; 
}
/*
//simple function, which take every basic block and try merge with 
//his predecessor
void TransformPhiInstrToSelect::tryJointBBWithPredessors(Function &F) {
  //let try merge bb
  Function::iterator iter=F.begin();
  for(;iter!=F.end();++iter) {
    BasicBlock * bb = iter;
    if(MergeBlockIntoPredecessor(bb)) {
      iter=F.begin();
    }
  }
}

bool TransformPhiInstrToSelect::runOnFunction(Function &F)
{ 
  bool bChanged = false;

  bool change=true;
  while(change) {
    change=false;
    if(testForTriangle(&F)) {
      tryJointBBWithPredessors(F);
      change=true;
    }
  }

  //TODO: return true only if the representation was changed
  return bChanged;
}*/
