/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#include "CodasipGenFrameLowering.h"
#include "CodasipInstrInfo.h"
#include "CodasipMachineFunction.h"
#include "CodasipTargetMachine.h"
#include "llvm/Function.h"
#include "llvm/CodeGen/MachineFrameInfo.h"
#include "llvm/CodeGen/MachineFunction.h"
#include "llvm/CodeGen/MachineInstrBuilder.h"
#include "llvm/ADT/Twine.h"

using namespace llvm;

CodasipGenFrameLowering::CodasipGenFrameLowering(const CodasipTargetMachine &tm)
: TargetFrameLowering(StackGrowsDown,4,0), TII(*tm.getInstrInfo()) {}

bool CodasipGenFrameLowering::hasFP(const MachineFunction &MF) const
{
  // note: this is used by hasReservedCallFrame as well
  return MF.getFrameInfo()->hasVarSizedObjects();
}

void CodasipGenFrameLowering::emitPrologue(MachineFunction &MF) const
{
  /*MachineBasicBlock &MB = MF.front();
  MachineBasicBlock::iterator II = MB.begin();
  DebugLoc dl;
  if (II != MB.end()) dl = II->getDebugLoc();
  MachineFrameInfo *MFI = MF.getFrameInfo();
  int Offset = MFI->getStackSize();
  // todo: make more efficient
  // save RAR (maybe simply ra as well later?)
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_signed__op_addiu__gpr_std__gpr_std__simm16__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addImm(-4);
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_loadstore__op_sw__gpr_std__simm16__gpr_std____SPEC_op0_0)).addReg(Codasip::gpregs_31).addReg(Codasip::gpregs_1);
  // save base index
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_signed__op_addiu__gpr_std__gpr_std__simm16__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addImm(-4);
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_loadstore__op_sw__gpr_std__simm16__gpr_std____SPEC_op0_0)).addReg(Codasip::gpregs_2).addReg(Codasip::gpregs_1);
  // set a new one
  BuildMI(MB,II,dl, TII.get(Codasip::instr_special_rrr__ops_movz__gpr_std__gpr_std__gpr0__), Codasip::gpregs_2).addReg(Codasip::gpregs_1);
  // allocate space?
  if (Offset)
  {
    if ((Offset&4294934528)!=4294934528 && (Offset&4294934528)!=0)
    {
      BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_lui__op_lui__gpr_std__uimm16__), Codasip::gpregs_30).addImm(Offset);
      BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_unsigned__op_ori__gpr_std__gpr_std__uimm16__), Codasip::gpregs_30).addReg(Codasip::gpregs_30).addImm(Offset);
      BuildMI(MB,II,dl, TII.get(Codasip::instr_special_rrr__ops_subu__gpr_std__gpr_std__gpr_std__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addReg(Codasip::gpregs_30);
    }
    else
    {
      BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_signed__op_addiu__gpr_std__gpr_std__simm16__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addImm(-Offset);
    }
  }
  // backup argument registers?
  if (MF.getFunction()->isVarArg())
  {
    CodasipFunctionInfo *finfo = MF.getInfo<CodasipFunctionInfo>();
    unsigned off;
    static const unsigned gpregs_args[] = {
      Codasip::gpregs_3, Codasip::gpregs_4, Codasip::gpregs_5, Codasip::gpregs_6, Codasip::gpregs_7, Codasip::gpregs_8, Codasip::gpregs_9, Codasip::gpregs_10, Codasip::gpregs_11, Codasip::gpregs_12, Codasip::gpregs_13, Codasip::gpregs_14, Codasip::gpregs_15, Codasip::gpregs_16, Codasip::gpregs_17, Codasip::gpregs_18, Codasip::gpregs_19, Codasip::gpregs_20, Codasip::gpregs_21, Codasip::gpregs_22, Codasip::gpregs_23, Codasip::gpregs_24, Codasip::gpregs_25, Codasip::gpregs_26, Codasip::gpregs_27, Codasip::gpregs_28, Codasip::gpregs_29, 
    };
    off = 27-finfo->ArgsInfo.Count_gpregs;
    for (int i=0; i<finfo->ArgsInfo.Count_gpregs; ++i) {
      BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_loadstore__op_sw__gpr_std__simm16__gpr_std__)).addReg(gpregs_args[i+off]).addFrameIndex(finfo->ArgsInfo.FI_gpregs).addImm(i*4);
    }
  }*/
}

void CodasipGenFrameLowering::emitEpilogue(MachineFunction &MF, MachineBasicBlock &MB) const
{
  /*MachineBasicBlock::iterator II = prior(MB.end());
  DebugLoc dl = II->getDebugLoc();
  MachineFrameInfo *MFI = MF.getFrameInfo();
  int Offset = MFI->getStackSize();
  // deallocate space?
  if ((Offset&4294934528)!=4294934528 && (Offset&4294934528)!=0)
  {
    BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_lui__op_lui__gpr_std__uimm16__), Codasip::gpregs_30).addImm(Offset);
    BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_unsigned__op_ori__gpr_std__gpr_std__uimm16__), Codasip::gpregs_30).addReg(Codasip::gpregs_30).addImm(Offset);
    BuildMI(MB,II,dl, TII.get(Codasip::instr_special_rrr__ops_addu__gpr_std__gpr_std__gpr_std__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addReg(Codasip::gpregs_30);
  }
  else
  {
    BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_signed__op_addiu__gpr_std__gpr_std__simm16__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addImm(Offset);
  }
  // restore base index
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_loadstore__op_lw__gpr_std__simm16__gpr_std____SPEC_op0_0), Codasip::gpregs_2).addReg(Codasip::gpregs_1);
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_signed__op_addiu__gpr_std__gpr_std__simm16__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addImm(4);
  // restore RAR
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_loadstore__op_lw__gpr_std__simm16__gpr_std____SPEC_op0_0), Codasip::gpregs_31).addReg(Codasip::gpregs_1);
  BuildMI(MB,II,dl, TII.get(Codasip::instr_direct_rri_signed__op_addiu__gpr_std__gpr_std__simm16__), Codasip::gpregs_1).addReg(Codasip::gpregs_1).addImm(4);
  */
}

