/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#define DEBUG_TYPE "delay-slot-filler"

#include "Codasip.h"
#include "CodasipTargetMachine.h"
#include "llvm/CodeGen/MachineFunctionPass.h"
#include "llvm/CodeGen/MachineInstrBuilder.h"
#include "llvm/Target/TargetInstrInfo.h"
#include "llvm/ADT/Statistic.h"

#include <set>

using namespace llvm;

namespace {
  struct Filler : public MachineFunctionPass {

    TargetMachine &TM;
    const TargetInstrInfo *TII;

    static char ID;
    Filler(TargetMachine &tm) 
      : MachineFunctionPass(ID), TM(tm), TII(tm.getInstrInfo()) { }

    virtual const char *getPassName() const {
      return "Codasip Delay Slot Filler";
    }

    bool runOnMachineBasicBlock(MachineFunction::iterator FI);
    bool runOnMachineFunction(MachineFunction &F) {
      bool Changed = false;
      for (MachineFunction::iterator FI = F.begin(), FE = F.end();
           FI != FE; ++FI)
        Changed |= runOnMachineBasicBlock(FI);
      return Changed;
    }

  };
  char Filler::ID = 0;
} // end of anonymous namespace

/// runOnMachineBasicBlock - Fill in delay slots for the given basic block.
/// Currently, we fill delay slots with NOPs. We assume there is only one
/// delay slot per delayed instruction.
/// Note: this will also take care of NOPs after inline-asm.
bool Filler::
runOnMachineBasicBlock(MachineFunction::iterator FI) 
{
  MachineBasicBlock &MBB = *FI;
  bool Changed = false;
  
  return Changed;
}

/// createCodasipDelaySlotFillerPass - Returns a pass that fills in delay
/// slots in Codasip MachineFunctions
FunctionPass *llvm::createCodasipDelaySlotFillerPass(CodasipTargetMachine &tm) {
  return new Filler(tm);
}

