#ifndef CODASIPMACHINEFUNCTIONINFO_H
#define CODASIPMACHINEFUNCTIONINFO_H

#include "llvm/ADT/SmallVector.h"
#include "llvm/ADT/VectorExtras.h"
#include "llvm/CodeGen/MachineFunction.h"
#include "llvm/CodeGen/MachineFrameInfo.h"

namespace llvm {

class CodasipFunctionInfo: public MachineFunctionInfo
{
  public:
    CodasipFunctionInfo(MachineFunction&) {StrctRetReg=0;}
    /** SRetReturnReg - Some subtargets require that sret lowering includes
     * returning the value of the returned struct in a register. This field
     * holds the virtual register into which the sret argument is passed. */
    unsigned StrctRetReg;
    /** Metainfo for varargs.
     * Creatud during analysis of formal arguments.
     * Intented for usage in prologue emition - va_start needs this in constants. */
    struct ArgsInfo {
      // backups of usable classes
      // how many regs; frame index; computed frame offset
      int Count_gpregs;
      int FI_gpregs;
      int FO_gpregs;
      /// The last fixed arg on the stack.
      int StackOff;
      /// Does the given frame index belong to a backup array?
      void SetBackupOff(int FI, int FO) {
        if (FI<0) return;
        if (FI_gpregs==FI) {
          FO_gpregs = FO;
          return;
        }
      }
    } ArgsInfo;
};

}

#endif
