/*******************************************************\
* Copyright (C) 2006, ApS s.r.o Brno, AllRightsReserved *
\*******************************************************/

#ifndef CODASIPTARGETMACHINE_H
#define CODASIPTARGETMACHINE_H

#include "llvm/Target/TargetData.h"
#include "llvm/Target/TargetMachine.h"
#include "llvm/Target/TargetFrameLowering.h"
#include "llvm/Module.h"

#include "CodasipInstrInfo.h"
#include "CodasipISelLowering.h"
#include "CodasipSubtarget.h"
#include "CodasipSelectionDAGInfo.h"
#include "CodasipFrameLowering.h"

namespace llvm {
  
  class CodasipTargetMachine : public LLVMTargetMachine {
    CodasipSubtarget Subtarget;
    const TargetData DataLayout;
    CodasipInstrInfo InstrInfo;
    CodasipFrameLowering FrameInfo;
    CodasipTargetLowering TLInfo;
    InstrItineraryData InstrItins;
    CodasipSelectionDAGInfo TSInfo;
    
    protected:
      virtual const CodasipSubtarget *getSubtargetImpl() const {return &Subtarget;}
    
    public:
      /// Constructor.
      CodasipTargetMachine
      (const Target &T, StringRef &TT, StringRef &FS, StringRef &CPU, Reloc::Model RM, CodeModel::Model CM);
      
      // virtual access methods
      virtual const TargetInstrInfo* getInstrInfo() const {
        return &InstrInfo;
      }
      virtual const TargetFrameLowering* getFrameLowering() const {
        return &FrameInfo;
      }
      virtual CodasipTargetLowering* getTargetLowering() const {
        return const_cast<CodasipTargetLowering*>(&TLInfo);
      }
      virtual const TargetData* getTargetData() const {
        return &DataLayout;
      }
      virtual const TargetRegisterInfo* getRegisterInfo() const {
        return &InstrInfo.getRegisterInfo();
      }
      virtual const InstrItineraryData* getInstrItineraryData() const {
        return &InstrItins;
      }
      virtual const CodasipSelectionDAGInfo* getSelectionDAGInfo() const {
        return &TSInfo;
      }
      
      // Passes
      virtual bool addInstSelector(PassManagerBase &PM, CodeGenOpt::Level OptLevel);
      virtual bool addPreRegAlloc(PassManagerBase &PM, CodeGenOpt::Level OptLevel);
      virtual bool addPreEmitPass(PassManagerBase &PM, CodeGenOpt::Level OptLevel);
  };
  
}

#endif
