----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use work.data_types.all;		-- my data types


package configure is


-- parametry obrazu
constant IMAGE_INPUT_W		: integer := 752;
constant IMAGE_INPUT_W_12	: integer := 63;		-- div12
constant IMAGE_INPUT_H		: integer := 480;

constant IMAGE_DETECT_W		: integer := 640;
constant IMAGE_DETECT_W_12	: integer := 54;     -- div12
constant IMAGE_DETECT_H		: integer := 480;
	

constant MEM_SCALE_ADR : array_13_int := (0,54,97,132,159,181,198,212,223,232,239,245,250);
constant MEM_SCALE_LEN : array_13_int := (640,512,410,328,263,211,167,134,108,87,70,56,45);
constant MEM_SCALE_L_12: array_13_int := (54,43,35,27,22,17,14,11,9,7,6,5,4);

constant ACC_ADD_VAL	: std_logic_vector(17 downto 0) := "111111111100000000";

constant MAX_TABLE	: std_logic_vector(9 downto 0) := "0100000000";
constant DETECT_ADDRES : std_logic_vector(31 downto 0) := X"00200000";

end configure;

package body configure is
 
end configure;
