----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all; 
use work.data_types.all;		-- my data types
use work.configure.all;		-- my data types
use IEEE.NUMERIC_STD.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity detect_control is
	port(
		CLK		: in std_logic;
		RESET		: in std_logic;
		ENABLE	: in std_logic;
		MEM_VALID 	: in std_logic;
		BUFFER_READY: in std_logic;

		DETECT_A	: in std_logic;
		DETECT_B	: in std_logic;
		
		BUSSY		: out std_logic;
		INIT		: out std_logic;
		
		SCALE_RESET	: out std_logic;
		
		TABLE_A	: out std_logic_vector(9 downto 0);
		POS_X_A	: out std_logic_vector(9 downto 0);
		POS_Y_A	: out std_logic_vector(9 downto 0);
		POS_S_A	: out std_logic_vector(3 downto 0);
		INDEX_A	: out std_logic_vector(3 downto 0);
		ENA_A		: out std_logic;
		FIRST_A	: out std_logic;
		MODE_A	: out std_logic_vector(1 downto 0);
		
		TABLE_B	: out std_logic_vector(9 downto 0);
		POS_X_B	: out std_logic_vector(9 downto 0);
		POS_Y_B	: out std_logic_vector(9 downto 0);
		POS_S_B	: out std_logic_vector(3 downto 0);
		INDEX_B	: out std_logic_vector(3 downto 0);
		ENA_B		: out std_logic;
		FIRST_B	: out std_logic;
		
		POSITIVE_A	: out std_logic;
		POSITIVE_B	: out std_logic;
		
		
		READ_ADDR	: out std_logic_vector(31 downto 0);
		READ_LEN		: out std_logic_vector(31 downto 0);
		READ_ENABLE	: out std_logic
	);
end detect_control;

architecture Behavioral of detect_control is

component chipskopeA
  PORT (
    CONTROL : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0);
    CLK : IN STD_LOGIC;
    TRIG0 : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
    TRIG1 : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
    TRIG2 : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
    TRIG3 : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
    TRIG4 : IN STD_LOGIC_VECTOR(3 DOWNTO 0);
    TRIG5 : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
    TRIG6 : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
    TRIG7 : IN STD_LOGIC_VECTOR(9 DOWNTO 0);
    TRIG8 : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
    TRIG9 : IN STD_LOGIC_VECTOR(31 DOWNTO 0);
    TRIG10 : IN STD_LOGIC_VECTOR(7 DOWNTO 0)
	 );
end component;

component chipsicon
  PORT (
    CONTROL0 : INOUT STD_LOGIC_VECTOR(35 DOWNTO 0));

end component;

-- vstupni automat
type state_type_in is (st0_in, st1_in, st2_in, st3_in, st4_in, st5_in, st6_in); 
signal state_in, next_state_in : state_type_in; 

-- generator pozice automat
type state_type_pos is (st0_pos, st1_pos, st2_pos, st3_pos, st4_pos); 
signal state_pos, next_state_pos : state_type_pos; 

signal write_mode 			: std_logic;
signal next_write_mode		: std_logic;

signal in_x, next_in_x		: std_logic_vector(9 downto 0):=(others => '0');
signal in_y, next_in_y		: std_logic_vector(9 downto 0):=(others => '0');
signal out_x, next_out_x	: std_logic_vector(9 downto 0):=(others => '0');
signal out_x2, next_out_x2	: std_logic_vector(9 downto 0):=(others => '0');
signal last_x, next_last_x	: std_logic_vector(9 downto 0):=(others => '0');
signal last_y, next_last_y	: std_logic_vector(9 downto 0):=(others => '0');
signal out_y, next_out_y	: std_logic_vector(9 downto 0):=(others => '0');
signal out_y2, next_out_y2	: std_logic_vector(9 downto 0):=(others => '0');

signal ena_detect_A			: std_logic;
signal ena_detect_B			: std_logic;

signal thread_id				: std_logic_vector(3 downto 0);
signal pre_thread_id			: std_logic_vector(3 downto 0);
signal first_begin			: std_logic_vector(9 downto 0);
signal next_first_begin		: std_logic_vector(9 downto 0);
signal ena_p					: std_logic_vector(9 downto 0);
signal next_ena_p				: std_logic_vector(9 downto 0);
signal pos_next_A				: std_logic;
signal pos_next_B				: std_logic;

signal next_firts_b			: std_logic;
signal next_pos_x_a			: std_logic_vector(9 downto 0);
signal next_pos_x_b			: std_logic_vector(9 downto 0);
signal next_pos_y_a			: std_logic_vector(9 downto 0);
signal next_pos_y_b			: std_logic_vector(9 downto 0);
signal next_ena_b				: std_logic;

signal next_init				: std_logic;

signal address, next_address	: std_logic_vector(31 downto 0);
signal mem_len, next_mem_len	: std_logic_vector(31 downto 0);

type array_10x10b is array(9 downto 0) of std_logic_vector(9 downto 0);
signal table_index_a			: array_10x10b;
signal table_index_b			: array_10x10b;
signal next_table_index_a	: array_10x10b;
signal next_table_index_b	: array_10x10b;
signal table_pos_x_a			: array_10x10b;
signal table_pos_x_b			: array_10x10b;
signal table_pos_y_a			: array_10x10b;
signal table_pos_y_b			: array_10x10b;
signal next_table_pos_x_a			: array_10x10b;
signal next_table_pos_x_b			: array_10x10b;
signal next_table_pos_y_a			: array_10x10b;
signal next_table_pos_y_b			: array_10x10b;

signal next_index_a, next_index_b : std_logic_vector(9 downto 0);

signal control  :  STD_LOGIC_VECTOR(35 DOWNTO 0);
signal debug	 : std_logic_vector(7 downto 0);
signal debug2	 : std_logic_vector(7 downto 0);

begin

SYNC_PROC_IN: process (CLK)
   begin
      if (CLK'event and CLK = '1') then
         if (next_init = '1' OR reset = '1') then
				address <= (others => '0');
				mem_len <= (others => '0');
            state_in <= st0_in;
				in_x <= (others => '0');
				in_y <= (others => '0');
         else
            state_in <= next_state_in;
				in_x <= next_in_x;
				in_y <= next_in_y;
				write_mode <= next_write_mode;
				address <= next_address;
				mem_len <= next_mem_len;
         end if;        
      end if;
   end process;
	
OUTPUT_DECODE_IN: process (state_in, BUFFER_READY, in_x, in_y, last_y, MEM_VALID, address, mem_len)
   begin
		next_in_x <= in_x;
		next_in_y <= in_y;
		next_write_mode <='0';
		READ_ADDR <= address;
		READ_LEN	<= mem_len;			
		READ_ENABLE <= '0';
		
		next_address <= address;	
		next_mem_len <= mem_len;
		if MEM_VALID = '1' then
			next_address <= address + 4;	
			next_mem_len <= mem_len - 1;
		end if;
		
      case (state_in) is
			when st0_in =>
				next_address <= (others => '0');
				next_mem_len <= X"000000A2";
				next_in_x <= (others => '0');
				next_in_y <= (others => '0');
         when st1_in =>
				if BUFFER_READY = '1' then					
					next_write_mode <='1';
				else 
					READ_ENABLE <= '1';
				end if;
         when st2_in =>
				if in_y < (last_y + 23) then
					next_in_y <= in_y + 1;
					next_in_x <= (others => '0');
					next_mem_len <= X"000000A2";
					next_address <= address + 104;
				end if;		
			when st3_in =>
			when st4_in =>
				next_in_x <= in_x +12;
			when st5_in =>	
			when st6_in =>	
			when others =>
      end case;  
   end process;

NEXT_STATE_DECODE_IN: process (state_in, BUFFER_READY, in_x, in_y, last_y, ENABLE)
   begin
      next_state_in <= state_in;
      case (state_in) is
			when st0_in =>
				if ENABLE = '1' then
					next_state_in <= st1_in;
				end if;
         when st1_in =>	
				if	BUFFER_READY = '1' then					
					next_state_in <= st4_in;				
				end if;
         when st2_in =>
				if in_y < (last_y + 23) then
					next_state_in <= st1_in;
				end if;
			when st3_in =>
				next_state_in <= st4_in;
			when st4_in =>
				next_state_in <= st5_in;
			when st5_in =>
				if in_x = 648 then
					if in_y = 479 then
						next_state_in <= st6_in;
					else
						next_state_in <= st2_in;
					end if;
				else
					next_state_in <= st1_in;
				end if;
			when st6_in =>	
				next_state_in <= st6_in;
         when others =>
				next_state_in <= st0_in;
      end case;
	end process;

----------------------------------------------------------------------------
----------------------------------------------------------------------------

priority_mux : process(write_mode,in_x,in_y)
begin
	if write_mode = '1' then
		POS_X_A <= 	in_x;
		POS_Y_A <= 	in_y;
		MODE_A  <= "11";
		TABLE_A <= "1111111111";
		ENA_A   <= '0';
		FIRST_A <= '0';
	else
		POS_X_A <= 	(others => '0');
		POS_Y_A <= 	(others => '0');
		MODE_A  <= "00";
		TABLE_A <= (others => '0');
		ENA_A   <= '0';
		FIRST_A <= '0';
	end if;
end process;	

----------------------------------------------------------------------------
----------------------------------------------------------------------------

SYNC_PROC_POS: process (CLK)
   begin
      if (CLK'event and CLK = '1') then
         if (RESET = '1') then
            state_pos <= st1_pos;
				out_x <= (others => '0');
				out_x2 <= (others => '0');
				last_x <= (others => '0');
				last_y <= (others => '0');
				out_y <= (others => '0');
				INIT <= '1';
         else
            state_pos <= next_state_pos;
				out_x <= next_out_x;
				out_x2 <= next_out_x2;
				last_x <= next_last_x;
				last_y <= next_last_y;
				out_y <= next_out_y;
				out_y2 <= next_out_y2;
				INIT <= next_init;
         end if;        
      end if;
   end process;
	
OUTPUT_DECODE_POS: process (state_pos, out_y, out_x, out_x2, last_x, pos_next_A, pos_next_B, write_mode, last_y)
   begin
		next_out_x <= out_x;
		next_out_x2 <= out_x2;
		next_out_y <= out_y;
		next_last_x <= last_x;
		next_last_y <= last_y;
		next_out_y2  <= last_y;
		ena_detect_A <= '0';
		ena_detect_B <= '0';
		BUSSY <= '0';
		next_init <= '0';
		
      case (state_pos) is
         when st1_pos =>
				next_init <= '1';
				next_out_x  <= "0000000001";
				next_out_x2 <= (others => '0');
				next_last_x <= "0000000001";
				next_out_y  <= (others => '0');
				next_out_y2 <= (others => '0');
				next_last_y <= (others => '0');
         when st2_pos =>
				BUSSY <= '1';
			when st3_pos =>			
				if (pos_next_A = '1') then
					if (pos_next_B = '1') then
						next_last_x <= last_x + 2;
						next_out_x  <= last_x + 1;
						next_out_y  <= last_y;
						next_out_x2 <= last_x + 2;
						next_out_y2  <= last_y;
					else
						next_last_x <= last_x + 1;
						next_out_x  <= last_x + 1;
						next_out_y  <= last_y;
					end if;
				elsif (pos_next_B = '1') then
					next_last_x  <= last_x + 1;
					next_out_x2  <= last_x + 1;
					next_out_y2  <= last_y;
				end if;
				ena_detect_A <= not write_mode;
				ena_detect_B <= '1';	
				BUSSY <= '1';
			when st4_pos =>
				next_out_x  <= "0000000001";
				next_out_x2 <= (others => '0');
				next_last_x <= "0000000001"; 
				next_last_y <= last_y + 1;
				BUSSY <= '1';
			when others =>
      end case;  
   end process;

NEXT_STATE_DECODE_POS: process (state_pos,  last_x, in_y, out_y, last_y, ENABLE )
   begin
      next_state_pos <= state_pos;
      case (state_pos) is
         when st1_pos =>
				if ENABLE = '1' then
					next_state_pos <= st2_pos;
				end if;
         when st2_pos =>	
				if (last_y +21) < in_y then
					next_state_pos <= st3_pos;
				end if;
			when st3_pos =>
				if last_x = 618 or last_x = 619 then
					next_state_pos <= st4_pos;
				end if;
			when st4_pos =>	
				if last_y = 457 then
					next_state_pos <= st1_pos;
				else
					next_state_pos <= st2_pos;
				end if;
			when others =>
				next_state_pos <= st0_pos;
      end case; 
	end process;

------------------------------------------------------------------------------------
------------------------------------------------------------------------------------	
feature_control_SYNC : process(CLK)
begin
	if (CLK'event and CLK = '1') then
         if (RESET = '1') then
				thread_id <= "0000";
				pre_thread_id <= "1001";
				first_begin <= "1111111111";
				ena_p <= "0000000000";
				FIRST_B <= '0';
         else
				if thread_id = "1001" then
					thread_id <= "0000";
				else
					thread_id <= thread_id + 1;
				end if;
				
				pre_thread_id <= thread_id;
				
				first_begin <= next_first_begin;
				ena_p <= next_ena_p;
				
				FIRST_B <= next_firts_b;
				POS_X_B <= next_pos_x_b;
				POS_Y_B <= next_pos_y_b;
				INDEX_B <= thread_id;
				ENA_B <= next_ena_b;
				table_index_b <= next_table_index_b;
				table_pos_x_b <= next_table_pos_x_b;
				table_pos_y_b <= next_table_pos_y_b;
				TABLE_B <= next_index_b;
         end if;        
      end if;
end process;

feature_control_OUT_B : process(ena_detect_B, first_begin, ena_p, DETECT_B, next_out_x2, out_y2, thread_id, pre_thread_id, table_index_b, table_pos_x_b, table_pos_y_b,out_x2)
begin
	next_first_begin <= first_begin;
	next_firts_b <= '0';
	next_pos_x_b <= (others => '0');
	next_pos_y_b <= (others => '0');
	next_ena_p   <= ena_p;
	next_ena_b <= '0';
	pos_next_B <= '0';
	next_index_b <= table_pos_x_b(conv_integer(thread_id));
	next_table_pos_x_b <= table_pos_x_b;
	next_table_pos_y_b <= table_pos_y_b;
	next_table_index_b <= table_index_b;
	POSITIVE_B <= '0';	
	debug2(6) <= '0';
	if ena_detect_B = '1' then
			next_ena_b <= '1';
			next_ena_p(conv_integer(thread_id)) <= '1';
	
		if first_begin(conv_integer(thread_id))='1' or (ena_p(conv_integer(pre_thread_id))='1' and  DETECT_B='0') or table_index_b(conv_integer(thread_id)) = MAX_TABLE then  -- prvni
			next_first_begin(conv_integer(thread_id)) <= '0';
			next_firts_b <= '1';			
			next_pos_x_b <= out_x2;
			next_table_pos_x_b(conv_integer(thread_id)) <= out_x2;
			next_pos_y_b <= out_y2;
			next_table_pos_y_b(conv_integer(thread_id)) <= out_y2;
			pos_next_B <= '1';			
			next_table_index_b(conv_integer(thread_id)) <= (others => '0');
			next_index_b <= (others => '0');
			if table_index_b(conv_integer(thread_id)) = MAX_TABLE then			
				POSITIVE_B <= '1';
				debug2(6) <= '1';
			end if;
		else
			next_pos_x_b <= table_pos_x_b(conv_integer(thread_id));
			next_pos_y_b <= table_pos_y_b(conv_integer(thread_id));
			
			if DETECT_B='1' then			
					next_table_index_b(conv_integer(thread_id)) <= table_index_b(conv_integer(thread_id)) + 1;
					next_index_b <= table_index_b(conv_integer(thread_id)) + 1;
			end if;			
		end if;

	end if;
end process;


POSITIVE_A <= '0';


------------------------------------------------------------------------------------
------------------------------------------------------------------------------------
POS_S_B <= "0000";


--ch_icon : chipsicon
--  port map ( CONTROL0 => control);
--  
--ch_scope : chipskopeA
--  port map (
--    CONTROL => control,
--    CLK => CLK,
--    TRIG0 => in_x,
--    TRIG1 => in_y,
--    TRIG2 => last_y,
--    TRIG3 => debug,	
--    TRIG4 => thread_id,
--    TRIG5 => next_pos_x_b,
--    TRIG6 => next_pos_y_b,
--	 --TRIG7 => (others => '0'),
--    TRIG7 => next_index_b,
--    TRIG8 => next_address,
--    TRIG9 => next_mem_len,
--    TRIG10 => debug2
--	 );
	
	debug(0) <= ena_detect_B;
	debug(7) <= BUFFER_READY;
	debug2(0) <= ena_detect_B;
	debug2(1) <=pos_next_B;
	debug2(2) <= DETECT_B;
	debug2(7) <= next_firts_b;
	
deb: process(state_pos, state_in)
begin
	case (state_pos) is
			when st0_pos =>
				debug(3 downto 1)<= "001";
         when st1_pos =>
				debug(3 downto 1)<= "010";
         when st2_pos =>
				debug(3 downto 1)<= "011";
			when st3_pos =>
				debug(3 downto 1)<= "100";
			when st4_pos =>
				debug(3 downto 1)<= "101";
			when others =>
			   debug(3 downto 1)<= "110";
      end case;
		
	 case (state_in) is
			when st0_in =>
				debug(6 downto 4)<= "001";
         when st1_in =>
				debug(6 downto 4)<= "010";
         when st2_in =>
				debug(6 downto 4)<= "011";
			when st3_in =>
				debug(6 downto 4)<= "100";
			when st4_in =>
				debug(6 downto 4)<= "101";
			when st5_in =>
				debug(6 downto 4)<= "110";
         when others =>
				debug(6 downto 4)<= "111";
      end case;	
	
end process;

end Behavioral;

