----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use work.data_types.all;		-- my data types

entity dsp is
		port(
				CLK				: in std_logic;
				
				-- výběr výsledného rozlišení subbloku, viz p_data_types.vhd
				OPTMODE			: in std_logic_vector(1 downto 0);
				
				-- vstupní data, 6 řádků 36 bitových dat
				DATA_IN			: in array_6x6x6b;
				
				-- výstupní data, po řádcích 9 hodnot po 6 bitech =>9x6 = 54 bitu
				DATA_OUT			: out dsp_out
				
		);	


end dsp;

architecture Behavioral of dsp is

	type dsp_inner7 is array (8 downto 0) of std_logic_vector (6 downto 0);
	type dsp_inner8 is array (8 downto 0) of std_logic_vector (7 downto 0);

	signal sig_1x1 : dsp_out;
	signal sig_1x2 : dsp_out;
	signal sig_2x1 : dsp_out;
	signal sig_2x2 : dsp_out;
	
	signal sig_1x2_i : dsp_inner7;
	signal sig_2x1_i : dsp_inner7;
	signal sig_2x2_i : dsp_inner8;

begin

	-- výstupní multiplexor
	DSP_OUT_MUX:process(CLK, OPTMODE, sig_1x1, sig_1x2, sig_2x1, sig_2x2)
	begin
		if (CLK'event and CLK = '1') then
			case OPTMODE is
				when "00" =>
					DATA_OUT <= sig_1x1;
				when "01" =>
					DATA_OUT <= sig_1x2;
				when "10" =>
					DATA_OUT <= sig_2x1;
				when "11" =>
					DATA_OUT <= sig_2x2;
				when others  =>
					DATA_OUT <= sig_1x1;
			end case;		
		end if;
	end process; -- DSP_OUT_MUX
		
	-- převod na matici 3x3
	GEN_MAT: for I in 0 to 2 generate
			GEN:for II in 0 to 2 generate
				sig_1x1  (3*I+II)	<= DATA_IN(I)(II);
				sig_1x2_i(3*I+II) <= '0'&DATA_IN(I)(2*II) + DATA_IN(I)(2*II+1);
				sig_2x1_i(3*I+II) <= '0'&DATA_IN(2*I)(II) + DATA_IN(2*I+1)(II);
				sig_2x2_i(3*I+II) <= "00"&DATA_IN(2*I)(2*II) + DATA_IN(2*I)(2*II+1)+
											DATA_IN(2*I+1)(2*II) + DATA_IN(2*I+1)(2*II+1);
			end generate;
		end generate;
		

	-- ořezaní posledních bitů
	GEN: for I in 0 to 8 generate
		sig_1x2(I) <= sig_1x2_i(I)(6 downto 1);
		sig_2x1(I) <= sig_2x1_i(I)(6 downto 1);
		sig_2x2(I) <= sig_2x2_i(I)(7 downto 2);
	end generate;
	
end Behavioral;

