----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------

----------------------------------------------------------------------------------
-- Pamet instrukci dvouportova
-- 36 bitove instrukce, maximalni pocet 512

-- 1 BRAM
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.data_types.all;		-- my data types
use IEEE.NUMERIC_STD.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity instruct_memory is
	port(
		CLK		: in std_logic;
		ADDR_A	: in std_logic_vector(9 downto 0);
		ADDR_B	: in std_logic_vector(9 downto 0);
		
		DATA_OUT_A	: out std_logic_vector(35 downto 0);
		DATA_OUT_B	: out std_logic_vector(35 downto 0);
		
		W_DATA	: in std_logic_vector(35 downto 0);	-- plnění
		W_ADDR	: in std_logic_vector(9 downto 0);
		W_ENA		: in std_logic
	);
end instruct_memory;

architecture Behavioral of instruct_memory is
	signal bram_addres_a	: std_logic_vector(13 downto 0);
	signal bram_addres_b	: std_logic_vector(13 downto 0);	
	

begin
	
	-- multiplexor pro vyber adresy pro port A ktery slouzi jak pro cteni a zapis	
	bram_addres_a(13 downto 5) <= ADDR_A(8 downto 0) when W_ENA = '0' else W_ADDR(8 downto 0);
	bram_addres_a( 4 downto 0) <= "00000";
	bram_addres_b <= ADDR_B(8 downto 0) & "00000";
		
	
	bram: RAMB16BWER
		generic map (
			DATA_WIDTH_A => 36, 
			DATA_WIDTH_B => 36, 
			WRITE_MODE_A => "NO_CHANGE",
			WRITE_MODE_B => "NO_CHANGE",
			--INIT_FILE => "instruct_memory_data_0.mif",
			--INITP_00 => X"0000000000000000000000000000000000000000000000000000000051463542",
			--INIT_00 => X"19230000 24350000 24560000 82560000 93340000 23560000 8f050000 97060000",
			--INIT_00 => X"1923000024350000245600008256000093340000235600008f05000097060000",
			INIT_00 => X"1923000024350000245600008256000093340000235600008f05000097060000",
			INIT_01 => X"bf1300001e4700002e580000ba140000870200001c280000ba580000aa470000",
			INIT_02 => X"a4250000a6470000a61400009c460000aa47000092450000850100003f150000",
			INIT_03 => X"17260000b4450000af06000081340000ba470000320300001912000018670000",
			INIT_04 => X"020500009708000011670000b316000040370000b4340000b706000014450000",
			INIT_05 => X"194500002446000026670000ca15000019350000290100003a3600000c450000",
			INIT_06 => X"9356000018370000c8240000c627000081120000a713000083020000aa060000",
			INIT_07 => X"8901000009010000b91500009756000002030000934700004014000010340000",
			INIT_08 => X"1c0100000e0300002406000003150000185700003d130000b618000038450000",
			INIT_09 => X"8e580000a4030000043800004045000001240000c6130000bc7800002e250000",
			INIT_0a => X"2c120000af7800001a47000034580000a8370000a6580000b728000083010000",
			INIT_0b => X"9b07000010360000ae580000bf3700008e250000304700002c24000012580000",
			INIT_0c => X"0c450000100300001a1400002078000016260000a1010000ae0800009e470000",
			INIT_0d => X"21450000c8370000b2280000af28000093260000b4470000bb6800003c030000",
			INIT_0e => X"8e4700001606000080150000854500001e36000038340000a556000029120000",
			INIT_0f => X"243500009937000091010000364700008c1200002837000027150000a2350000",
			INIT_10 => X"82260000143400009a030000ac24000026360000b03600003328000014130000",
			INIT_11 => X"a114000014250000ab2700003e4800000268000093380000352400008f380000",
			INIT_12 => X"210400009628000080040000351600002448000097050000ac5800008d380000",
			INIT_13 => X"46040000c268000032360000194500004a04000080360000bc14000099160000",
			INIT_14 => X"b13700000c0300001478000086260000af1800001723000086080000bf260000",
			INIT_15 => X"40340000a0150000227800003e36000030140000034600000f0800008e250000",
			INIT_16 => X"03040000405700001268000024380000c8570000020800003026000085460000",
			INIT_17 => X"9c360000330600003c140000a80100003f1800004a2400009c38000011670000",
			INIT_18 => X"ad1500000c6800000d680000a6670000284700000d1200008635000022130000",
			INIT_19 => X"070600001326000005460000801300001134000039260000b513000098470000",
			INIT_1a => X"0c470000bd0500009015000002030000c0370000a85800000615000084360000",
			INIT_1b => X"18380000062800009f280000c012000099010000b82700008c01000027250000",
			INIT_1c => X"144700004258000004340000b0280000154800002f670000040100001c450000",
			INIT_1d => X"48450000240300001447000021350000355700000b0700003658000018450000",
			INIT_1e => X"a738000046350000a90100002c140000000400008f340000b206000008360000",
			INIT_1f => X"244600003923000004020000c207000090030000844800001406000034470000",
			INIT_20 => X"104700003c0300003036000033060000ae1400009b1500008225000082260000",
			INIT_21 => X"90360000b1380000352300000c4800001403000032250000b0580000b2250000",
			INIT_22 => X"be360000a0480000b13700003c370000b84700009b0500008d12000024010000",
			INIT_23 => X"8b26000029020000ca38000092140000884700000c0100000f16000007030000",
			INIT_24 => X"9702000087140000b5160000844600002115000016140000a445000004360000",
			INIT_25 => X"4457000000570000832800000046000094010000483400009a12000027160000",
			INIT_26 => X"ba4500001368000023120000125600002306000025120000485600009a050000",
			INIT_27 => X"aa470000914600003a2500009a380000303400002e1400008a56000089010000",
			INIT_28 => X"a856000002080000bf050000be0300002738000080150000b515000033280000",
			INIT_29 => X"20450000ab080000a108000094470000bc2700008508000000130000a0680000",
			INIT_2a => X"2804000002470000c0670000bb23000098480000233700002306000026030000",
			INIT_2b => X"241500001448000026780000a2130000ae3600002c160000c846000018450000",
			INIT_2c => X"10680000200800009d0200003e0300002d470000b81400003a450000ac580000",
			INIT_2d => X"0a6800008d5600008c01000083340000b5080000bc470000800200000b020000",
			INIT_2e => X"b9140000240100003d37000087030000b5080000a01400003c5700008f350000",
			INIT_2f => X"a46700002b0400000524000002070000003400008e14000034060000b0470000",
			INIT_30 => X"c6050000b43500001703000016560000ae240000ca680000072600003e180000",
			INIT_31 => X"1c4700001926000048480000081500001928000097260000aa67000096050000",
			INIT_32 => X"98780000aa4700008c4800003e1200008512000028360000ac360000ac160000",
			INIT_33 => X"854800008a030000b406000008270000c6560000a4020000120800009c050000",
			INIT_34 => X"847800001467000083010000266700009b680000102500000606000038140000",
			INIT_35 => X"25150000884600001014000009180000b5040000a468000044480000bd160000",
			INIT_36 => X"210700003f450000823500002e250000200500003c1400008034000016250000",
			INIT_37 => X"3a3700002a1400002a36000018470000ba2700009a2800009834000093080000",
			INIT_38 => X"05450000ab46000020010000a1480000c2250000ad460000a201000007020000",
			INIT_39 => X"9d4600008b6800003e030000c83400000f2300001d340000107800008f180000",
			INIT_3a => X"955700002a580000ab260000122600008a24000008370000b1150000c6260000",
			INIT_3b => X"24060000c22700009112000003010000b4230000be680000304700009d360000",
			INIT_3c => X"89560000be14000095340000a73600002e080000a04600008258000028130000",
			INIT_3d => X"2a380000ca6800004a3800001b6800003c47000027020000a35600008e350000",
			INIT_3e => X"986700002c580000a00400003728000082350000a1370000ba03000034170000",
			INIT_3f => X"000000003b060000244500003715000048240000354600001802000038070000",
			INITP_00 => X"4610074756553473235106522477344234360543477332516400066751463542",
			INITP_01 => X"1157273511730585524313243065372353617427354552344424154350463844",
			INITP_02 => X"1642547206456332452251641363023130663853467465344624217445230126",
			INITP_03 => X"5593370507559039457782242003523650145654703123635512238418751655",
			INITP_04 => X"7344405312734234692125304531463855456531152346576452527528630263",
			INITP_05 => X"3322010343136463647284675267343766205377704370614252612354457603",
			INITP_06 => X"0454570422466562072222271056563476403462655745135138052443632642",
			INITP_07 => X"0230830324535635354254105350537587548153375378215305728435555502",
			SIM_DEVICE => "SPARTAN6"
		)
		port map (		
		DIA (31 downto 0) => W_DATA(31 downto 0),
		DIPA (3 downto 0) => W_DATA(35 downto 32),	
		
		ADDRA => bram_addres_a,
		WEA	=> (others => '0'),
		ENA	=> '1',
		RSTA	=> '0',
		REGCEA=> '0',
		CLKA	=> CLK, 
		
		DIB  (31 downto 0) => (others => '0'),
		DIPB (3 downto 0)	 => (others => '0'),
		ADDRB => bram_addres_b,
		WEB	=> (others => '0'),
		ENB	=> '1',
		RSTB	=> '0',
		REGCEB=> '0',
		CLKB	=> CLK,
		
		DOA (31 downto 0) => DATA_OUT_A(31 downto 0),
		DOPA (3 downto 0) => DATA_OUT_A(35 downto 32),
		
		DOB (31 downto 0) => DATA_OUT_B(31 downto 0),
		DOPB (3 downto 0) => DATA_OUT_B(35 downto 32)
	);

end Behavioral;

