----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------

----------------------------------------------------------------------------------
-- Jedenáctibitová modulo 12 (vstup 0-1535)
--
-- 
--
-- Petr Musil
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity mod12 is
    Port ( input : in  STD_LOGIC_VECTOR (10 downto 0);
           output : out  STD_LOGIC_VECTOR (3 downto 0));
end mod12;

architecture Behavioral of mod12 is

	signal out0, out1, out2 : std_logic;

begin

ROM256X1_inst0 : ROM256X1
   generic map (
      INIT => X"2492492492492492492492492492492492492492492492492492492492492492")
   port map (
      O => out0,   -- ROM output
      A0 => input(2), -- ROM address[0]
      A1 => input(3), -- ROM address[1]
      A2 => input(4), -- ROM address[2]
      A3 => input(5), -- ROM address[3]
      A4 => input(6), -- ROM address[4]
      A5 => input(7), -- ROM address[5]
      A6 => input(8),  -- ROM address[6]
      A7 => input(9)  -- ROM address[7]
   );
	
ROM256X1_inst1 : ROM256X1
   generic map (
      INIT => X"4924924924924924924924924924924924924924924924924924924924924924")
   port map (
      O => out1,   -- ROM output
      A0 => input(2), -- ROM address[0]
      A1 => input(3), -- ROM address[1]
      A2 => input(4), -- ROM address[2]
      A3 => input(5), -- ROM address[3]
      A4 => input(6), -- ROM address[4]
      A5 => input(7), -- ROM address[5]
      A6 => input(8),  -- ROM address[6]
      A7 => input(9)  -- ROM address[7]
   );
	
ROM256X1_inst2 : ROM256X1
   generic map (
      INIT => X"9249249249249249249249249249249249249249249249249249249249249249")
   port map (
      O => out2,   -- ROM output
      A0 => input(2), -- ROM address[0]
      A1 => input(3), -- ROM address[1]
      A2 => input(4), -- ROM address[2]
      A3 => input(5), -- ROM address[3]
      A4 => input(6), -- ROM address[4]
      A5 => input(7), -- ROM address[5]
      A6 => input(8),  -- ROM address[6]
      A7 => input(9)  -- ROM address[7]
   );
	
mux: process(input, out0, out1, out2)
begin
	case input(10) is
		when '0' =>   output <= out1&out0&input(1 downto 0);
		when '1' =>   output <= out0&out2&input(1 downto 0);
		when others => output <= out1&out0&input(1 downto 0);
	end case;
end process;


end Behavioral;
