----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------
-- retiming pls

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use work.data_types.all;		-- my data types

entity mux_engine is
	port(
		CLK		: in std_logic;
		DATA_A	: in array_12x36b;
		DATA_B	: in array_12x36b;
		H_SHUFFLE	: in std_logic;
		V_SHUFFLE	: in std_logic_vector(3 downto 0);
		C_SHUFFLE	: in std_logic_vector(2 downto 0);
		
		DATA_OUT	: out array_8x6x6b
	);
end mux_engine;

architecture Behavioral of mux_engine is

type array_8x36b is array (7 downto 0) of std_logic_vector(35 downto 0);
signal data_h_A, data_h_B : array_12x36b;
signal data_v_A, data_v_B : array_8x36b;
signal data					  : array_8x6x6b;

begin

SYNC_PROC: process (CLK, data)
   begin
      if (CLK'event and CLK = '1') then
			DATA_OUT <= data;
		end if;
end process;

h_mux: process ( H_SHUFFLE, DATA_A, DATA_B)
	begin
		if H_SHUFFLE = '1' then
			data_h_A <= DATA_B;
			data_h_B <= DATA_A;
		else
			data_h_A <= DATA_A;
			data_h_B <= DATA_B;
		end if;
end process;

v_mux: process ( V_SHUFFLE, data_h_A, data_h_B)
	begin
		case V_SHUFFLE is
			when "0000" =>
				data_v_A(0) <= data_h_A(0);
				data_v_A(1) <= data_h_A(1);
				data_v_A(2) <= data_h_A(2);
				data_v_A(3) <= data_h_A(3);
				data_v_A(4) <= data_h_A(4);				
				data_v_A(5) <= data_h_A(5);
				data_v_A(6) <= data_h_A(6);
				data_v_A(7) <= data_h_A(7);
				
				data_v_B(0) <= data_h_B(0);
				data_v_B(1) <= data_h_B(1);
				data_v_B(2) <= data_h_B(2);
				data_v_B(3) <= data_h_B(3);
				data_v_B(4) <= data_h_B(4);				
				data_v_B(5) <= data_h_B(5);
				data_v_B(6) <= data_h_B(6);
				data_v_B(7) <= data_h_B(7);
				
			when "0001" =>
				data_v_A(0) <= data_h_A(1);
				data_v_A(1) <= data_h_A(2);
				data_v_A(2) <= data_h_A(3);
				data_v_A(3) <= data_h_A(4);
				data_v_A(4) <= data_h_A(5);				
				data_v_A(5) <= data_h_A(6);
				data_v_A(6) <= data_h_A(7);
				data_v_A(7) <= data_h_A(8);
				
				data_v_B(0) <= data_h_B(1);
				data_v_B(1) <= data_h_B(2);
				data_v_B(2) <= data_h_B(3);
				data_v_B(3) <= data_h_B(4);
				data_v_B(4) <= data_h_B(5);				
				data_v_B(5) <= data_h_B(6);
				data_v_B(6) <= data_h_B(7);
				data_v_B(7) <= data_h_B(8);
			when "0010" =>
				data_v_A(0) <= data_h_A(2);
				data_v_A(1) <= data_h_A(3);
				data_v_A(2) <= data_h_A(4);
				data_v_A(3) <= data_h_A(5);
				data_v_A(4) <= data_h_A(6);				
				data_v_A(5) <= data_h_A(7);
				data_v_A(6) <= data_h_A(8);
				data_v_A(7) <= data_h_A(9);
				
				data_v_B(0) <= data_h_B(2);
				data_v_B(1) <= data_h_B(3);
				data_v_B(2) <= data_h_B(4);
				data_v_B(3) <= data_h_B(5);
				data_v_B(4) <= data_h_B(6);				
				data_v_B(5) <= data_h_B(7);
				data_v_B(6) <= data_h_B(8);
				data_v_B(7) <= data_h_B(9);
			when "0011" =>
				data_v_A(0) <= data_h_A(3);
				data_v_A(1) <= data_h_A(4);
				data_v_A(2) <= data_h_A(5);
				data_v_A(3) <= data_h_A(6);
				data_v_A(4) <= data_h_A(7);				
				data_v_A(5) <= data_h_A(8);
				data_v_A(6) <= data_h_A(9);
				data_v_A(7) <= data_h_A(10);
				
				data_v_B(0) <= data_h_B(3);
				data_v_B(1) <= data_h_B(4);
				data_v_B(2) <= data_h_B(5);
				data_v_B(3) <= data_h_B(6);
				data_v_B(4) <= data_h_B(7);				
				data_v_B(5) <= data_h_B(8);
				data_v_B(6) <= data_h_B(9);
				data_v_B(7) <= data_h_B(10);
			when "0100" =>
				data_v_A(0) <= data_h_A(4);
				data_v_A(1) <= data_h_A(5);
				data_v_A(2) <= data_h_A(6);
				data_v_A(3) <= data_h_A(7);
				data_v_A(4) <= data_h_A(8);				
				data_v_A(5) <= data_h_A(9);
				data_v_A(6) <= data_h_A(10);
				data_v_A(7) <= data_h_A(11);
				
				data_v_B(0) <= data_h_B(4);
				data_v_B(1) <= data_h_B(5);
				data_v_B(2) <= data_h_B(6);
				data_v_B(3) <= data_h_B(7);
				data_v_B(4) <= data_h_B(8);				
				data_v_B(5) <= data_h_B(9);
				data_v_B(6) <= data_h_B(10);
				data_v_B(7) <= data_h_B(11);
			when "0101" =>
				data_v_A(0) <= data_h_A(5);
				data_v_A(1) <= data_h_A(6);
				data_v_A(2) <= data_h_A(7);
				data_v_A(3) <= data_h_A(8);
				data_v_A(4) <= data_h_A(9);				
				data_v_A(5) <= data_h_A(10);
				data_v_A(6) <= data_h_A(11);
				data_v_A(7) <= data_h_A(0);
				
				data_v_B(0) <= data_h_B(5);
				data_v_B(1) <= data_h_B(6);
				data_v_B(2) <= data_h_B(7);
				data_v_B(3) <= data_h_B(8);
				data_v_B(4) <= data_h_B(9);				
				data_v_B(5) <= data_h_B(10);
				data_v_B(6) <= data_h_B(11);
				data_v_B(7) <= data_h_B(0);
			when "0110" =>
				data_v_A(0) <= data_h_A(6);
				data_v_A(1) <= data_h_A(7);
				data_v_A(2) <= data_h_A(8);
				data_v_A(3) <= data_h_A(9);
				data_v_A(4) <= data_h_A(10);				
				data_v_A(5) <= data_h_A(11);
				data_v_A(6) <= data_h_A(0);
				data_v_A(7) <= data_h_A(1);
				
				data_v_B(0) <= data_h_B(6);
				data_v_B(1) <= data_h_B(7);
				data_v_B(2) <= data_h_B(8);
				data_v_B(3) <= data_h_B(9);
				data_v_B(4) <= data_h_B(10);				
				data_v_B(5) <= data_h_B(11);
				data_v_B(6) <= data_h_B(0);
				data_v_B(7) <= data_h_B(1);
			when "0111" =>
				data_v_A(0) <= data_h_A(7);
				data_v_A(1) <= data_h_A(8);
				data_v_A(2) <= data_h_A(9);
				data_v_A(3) <= data_h_A(10);
				data_v_A(4) <= data_h_A(11);				
				data_v_A(5) <= data_h_A(0);
				data_v_A(6) <= data_h_A(1);
				data_v_A(7) <= data_h_A(2);
				
				data_v_B(0) <= data_h_B(7);
				data_v_B(1) <= data_h_B(8);
				data_v_B(2) <= data_h_B(9);
				data_v_B(3) <= data_h_B(10);
				data_v_B(4) <= data_h_B(11);				
				data_v_B(5) <= data_h_B(0);
				data_v_B(6) <= data_h_B(1);
				data_v_B(7) <= data_h_B(2);
			when "1000" =>
				data_v_A(0) <= data_h_A(8);
				data_v_A(1) <= data_h_A(9);
				data_v_A(2) <= data_h_A(10);
				data_v_A(3) <= data_h_A(11);
				data_v_A(4) <= data_h_A(0);				
				data_v_A(5) <= data_h_A(1);
				data_v_A(6) <= data_h_A(2);
				data_v_A(7) <= data_h_A(3);
				
				data_v_B(0) <= data_h_B(8);
				data_v_B(1) <= data_h_B(9);
				data_v_B(2) <= data_h_B(10);
				data_v_B(3) <= data_h_B(11);
				data_v_B(4) <= data_h_B(0);				
				data_v_B(5) <= data_h_B(1);
				data_v_B(6) <= data_h_B(2);
				data_v_B(7) <= data_h_B(3);
			when "1001" =>
				data_v_A(0) <= data_h_A(9);
				data_v_A(1) <= data_h_A(10);
				data_v_A(2) <= data_h_A(11);
				data_v_A(3) <= data_h_A(0);
				data_v_A(4) <= data_h_A(1);				
				data_v_A(5) <= data_h_A(2);
				data_v_A(6) <= data_h_A(3);
				data_v_A(7) <= data_h_A(4);
				
				data_v_B(0) <= data_h_B(9);
				data_v_B(1) <= data_h_B(10);
				data_v_B(2) <= data_h_B(11);
				data_v_B(3) <= data_h_B(0);
				data_v_B(4) <= data_h_B(1);				
				data_v_B(5) <= data_h_B(2);
				data_v_B(6) <= data_h_B(3);
				data_v_B(7) <= data_h_B(4);
			when "1010" =>
				data_v_A(0) <= data_h_A(10);
				data_v_A(1) <= data_h_A(11);
				data_v_A(2) <= data_h_A(0);
				data_v_A(3) <= data_h_A(1);
				data_v_A(4) <= data_h_A(2);				
				data_v_A(5) <= data_h_A(3);
				data_v_A(6) <= data_h_A(4);
				data_v_A(7) <= data_h_A(5);
				
				data_v_B(0) <= data_h_B(10);
				data_v_B(1) <= data_h_B(11);
				data_v_B(2) <= data_h_B(0);
				data_v_B(3) <= data_h_B(1);
				data_v_B(4) <= data_h_B(2);				
				data_v_B(5) <= data_h_B(3);
				data_v_B(6) <= data_h_B(4);
				data_v_B(7) <= data_h_B(5);
			when "1011" =>
				data_v_A(0) <= data_h_A(11);
				data_v_A(1) <= data_h_A(0);
				data_v_A(2) <= data_h_A(1);
				data_v_A(3) <= data_h_A(2);
				data_v_A(4) <= data_h_A(3);				
				data_v_A(5) <= data_h_A(4);
				data_v_A(6) <= data_h_A(5);
				data_v_A(7) <= data_h_A(6);
				
				data_v_B(0) <= data_h_B(11);
				data_v_B(1) <= data_h_B(0);
				data_v_B(2) <= data_h_B(1);
				data_v_B(3) <= data_h_B(2);
				data_v_B(4) <= data_h_B(3);				
				data_v_B(5) <= data_h_B(4);
				data_v_B(6) <= data_h_B(5);
				data_v_B(7) <= data_h_B(6);
			when others =>
				data_v_A(0) <= data_h_A(0);
				data_v_A(1) <= data_h_A(1);
				data_v_A(2) <= data_h_A(2);
				data_v_A(3) <= data_h_A(3);
				data_v_A(4) <= data_h_A(4);				
				data_v_A(5) <= data_h_A(5);
				data_v_A(6) <= data_h_A(6);
				data_v_A(7) <= data_h_A(7);
				
				data_v_B(0) <= data_h_B(0);
				data_v_B(1) <= data_h_B(1);
				data_v_B(2) <= data_h_B(2);
				data_v_B(3) <= data_h_B(3);
				data_v_B(4) <= data_h_B(4);				
				data_v_B(5) <= data_h_B(5);
				data_v_B(6) <= data_h_B(6);
				data_v_B(7) <= data_h_B(7);
		end case;
end process;

c_mux_gen:for N in 0 to 7 generate
	c_mux: process ( C_SHUFFLE, data_v_A, data_v_B)
	begin
		case C_SHUFFLE is
			when "000" =>
				data(N)(0) <= data_v_A(N)(5 downto 0)	;data(N)(1) <= data_v_A(N)(11 downto 6);
				data(N)(2) <= data_v_A(N)(17 downto 12);data(N)(3) <= data_v_A(N)(23 downto 18);
				data(N)(4) <= data_v_A(N)(29 downto 24);data(N)(5) <= data_v_A(N)(35 downto 30);
			when "001" =>	
				data(N)(0) <= data_v_A(N)(11 downto 6); data(N)(1) <= data_v_A(N)(17 downto 12);
				data(N)(2) <= data_v_A(N)(23 downto 18);data(N)(3) <= data_v_A(N)(29 downto 24);
				data(N)(4) <= data_v_A(N)(35 downto 30);data(N)(5) <= data_v_B(N)(5 downto 0);
			when "010" =>
				data(N)(0) <= data_v_A(N)(17 downto 12);data(N)(1) <= data_v_A(N)(23 downto 18);
				data(N)(2) <= data_v_A(N)(29 downto 24);data(N)(3) <= data_v_A(N)(35 downto 30);
				data(N)(4) <= data_v_B(N)(5 downto 0)	;data(N)(5) <= data_v_B(N)(11 downto 6);
			when "011" =>
				data(N)(0) <= data_v_A(N)(23 downto 18);data(N)(1) <= data_v_A(N)(29 downto 24);
				data(N)(2) <= data_v_A(N)(35 downto 30);data(N)(3) <= data_v_B(N)(5 downto 0);
				data(N)(4) <= data_v_B(N)(11 downto 6) ;data(N)(5) <= data_v_B(N)(17 downto 12);
			when "100" =>
				data(N)(0) <= data_v_A(N)(29 downto 24);data(N)(1) <= data_v_A(N)(35 downto 30);
				data(N)(2) <= data_v_B(N)(5 downto 0)  ;data(N)(3) <= data_v_B(N)(11 downto 6) ;
				data(N)(4) <= data_v_B(N)(17 downto 12);data(N)(5) <= data_v_B(N)(23 downto 18);
			when "101" =>
				data(N)(0) <= data_v_A(N)(35 downto 30);data(N)(1) <= data_v_B(N)(5 downto 0)  ;
				data(N)(2) <= data_v_B(N)(11 downto 6) ;data(N)(3) <= data_v_B(N)(17 downto 12);
				data(N)(4) <= data_v_B(N)(23 downto 18);data(N)(5) <= data_v_B(N)(29 downto 24);
			when others =>
				data(N)(0) <= data_v_A(N)(5 downto 0);  data(N)(1) <= data_v_A(N)(11 downto 6);
				data(N)(2) <= data_v_A(N)(17 downto 12);data(N)(3) <= data_v_A(N)(23 downto 18);
				data(N)(4) <= data_v_A(N)(29 downto 24);data(N)(5) <= data_v_A(N)(35 downto 30);

		end case;
	end process;
end generate;

end Behavioral;

