----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.data_types.all;		-- moje datové typy
use IEEE.NUMERIC_STD.ALL;
library UNISIM;
use UNISIM.VComponents.all;

entity treshold_memory18 is
	port(
		CLK	: in std_logic;
		ADDR_A	: in std_logic_vector( 9 downto 0 );
		ADDR_B	: in std_logic_vector( 9 downto 0 );
		
		DATA_OUT_A	: out std_logic_vector( 17 downto 0 );
		DATA_OUT_B	: out std_logic_vector( 17 downto 0 );
		
		W_ADDR	: in std_logic_vector( 9 downto 0) ;
		W_DATA	: in std_logic_vector( 17 downto 0 );
		W_ENA		: in std_logic
	);
end treshold_memory18;

architecture Behavioral of treshold_memory18 is

	signal bram_addres_A : std_logic_vector(13 downto 0);
	signal bram_addres_B : std_logic_vector(13 downto 0);
	
	signal write_ena : std_logic_vector(3 downto 0);
	
	signal zero	: std_logic_vector(17 downto 0);
	
begin

	mux_addres: process(W_ENA, ADDR_A, W_ADDR)
	begin
		if W_ENA = '1' then
			bram_addres_A <= W_ADDR(9 downto 0) & "0000";
		else
			bram_addres_A <= ADDR_A(9 downto 0) & "0000";
		end if;
	end process;
	
	-- nastavení signálu pro povolení zápisu	
	write_ena<=W_ENA&W_ENA&W_ENA&W_ENA;
	bram_addres_B <= ADDR_B(9 downto 0) & "0000";

	
	
	bram: RAMB16BWER
		generic map (
			DATA_WIDTH_A => 18, 
			DATA_WIDTH_B => 18, 
			WRITE_MODE_A => "NO_CHANGE",
			WRITE_MODE_B => "NO_CHANGE",
			--INIT_FILE => "treshold_memory_data_0.mif",
			INIT_00 => X"0f160f200f3a0f3d0f430f330f4f0f350f5200000f740f710f810fab0fd70ffe",
			INIT_01 => X"0ef90f0900000f000ee90ee30ef90efd0f04000000000f240f130f0d0f1a0f24",
			INIT_02 => X"0ed600000ed9000000000000000000000ef10eed0ee80eea0ee10edd0ee90ee4",
			INIT_03 => X"00000ec30ebb00000000000000000000000000000ee20ec70ebe0ed20ed80ee7",
			INIT_04 => X"0ec60ed00ecc0ed30ecb0ebe0eab0eb00eb30ebe0ecb0ed50ec80eb600000000",
			INIT_05 => X"0e940e870ea50eb50eae0eb30ea90eb80ece0ebb0eb10ec40ebf0ebd0ec40ece",
			INIT_06 => X"00000ebe0eb40ebc0eba0eb80ec40eca0eb80ec30ebb0ea80e9e0ea50ea30ea7",
			INIT_07 => X"0e940ea30e9a0e880e760e790e670e6e0e730ead0eb40eb20ec1000000000000",
			INIT_08 => X"0e960e9a0e930e8e0ebc0ea70eb10ea40e930e9d0e9d0eaf0eac0ea30e9e0eb0",
			INIT_09 => X"0eae0ea60eaa0ea90eb40eb50ea40eac0ea60ebc0ea30ea20e9a0e940e8f0e88",
			INIT_0a => X"0e920e9b0e9d0e930e9a0ea20ea30ea20eab0ea60eae0ea80eae0eaa0ebe0ec0",
			INIT_0b => X"000000000000000000000000000000000000000000000000000000000e970e94",
			INIT_0c => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_0d => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_0e => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_0f => X"0555000000000000000000000000000000000000000000000000000000000000",
			INIT_10 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_11 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_12 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_13 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_14 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_15 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_16 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_17 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_18 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_19 => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_1a => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_1b => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_1c => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_1d => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_1e => X"0000000000000000000000000000000000000000000000000000000000000000",
			INIT_1f => X"0000000000000000000000000000000000000000000000000000000000000000",
			SIM_DEVICE => "SPARTAN6"
		)
		port map (		
		DIA (31 downto 24)=> (others => '0'),
		DIA (23 downto 16)=> (others => '0'),
		DIA (15 downto 8) => W_DATA(15 downto 8),
		DIA (7 downto 0)  => W_DATA(7 downto 0),
		DIPA (3) => '0',
		DIPA (2) => '0',
		DIPA (1) => W_DATA(17),
		DIPA (0) => W_DATA(16),		
		
		ADDRA => bram_addres_A,
		WEA	=> write_ena,
		ENA	=> '1',
		RSTA	=> '0',
		REGCEA=> '0',
		CLKA	=> CLK, 
		
		DIB  (31 downto 0) => (others => '0'),
		DIPB (3 downto 0)	 => (others => '0'),
		ADDRB => bram_addres_B,
		WEB	=> (others => '0'),
		ENB	=> '1',
		RSTB	=> '0',
		REGCEB=> '0',
		CLKB	=> CLK,
		
		DOA (31 downto 24)=> zero(17 downto 10),
		DOA (23 downto 16)=> zero(8 downto 1),
		DOA (15 downto 8) => DATA_OUT_A(15 downto 8),
		DOA (7 downto 0)  => DATA_OUT_A(7 downto 0),
		DOPA (3) => zero(9),
		DOPA (2) => zero(0),
		DOPA (1) => DATA_OUT_A(17),
		DOPA (0) => DATA_OUT_A(16),
		
		
		DOB (31 downto 24)=> zero(17 downto 10),
		DOB (23 downto 16)=> zero(8 downto 1),
		DOB (15 downto 8) => DATA_OUT_B(15 downto 8),
		DOB (7 downto 0)  => DATA_OUT_B(7 downto 0),
		DOPB (3) => zero(9),
		DOPB (2) => zero(0),
		DOPB (1) => DATA_OUT_B(17),
		DOPB (0) => DATA_OUT_B(16)
		);

end Behavioral;

