----------------------------------------------------------------------------------
-- Detektor objektu
-- Copyright (C) 2012 Brno University of Technology,
--                        Faculty of Information Technology
-- Author(s): Petr Musil <xmusilpetr AT fit.vutbr.cz>
--  
-- LICENSE TERMS
--  
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 	1. Redistributions of source code must retain the above copyright
-- 	notice, this list of conditions and the following disclaimer.
-- 	2. Redistributions in binary form must reproduce the above copyright
-- 	notice, this list of conditions and the following disclaimer in
-- 	the documentation and/or other materials provided with the
-- 	distribution.
-- 	3. All advertising materials mentioning features or use of this software
-- 	or firmware must display the following acknowledgement:
--   
-- 	This product includes software developed by the University of
-- 	Technology, Faculty of Information Technology, Brno and its
-- 	contributors.
--  
-- 	4. Neither the name of the Company nor the names of its contributors
-- 	may be used to endorse or promote products derived from this
-- 	software without specific prior written permission.
--  
-- This software or firmware is provided ``as is'', and any express or implied
-- warranties, including, but not limited to, the implied warranties of
-- merchantability and fitness for a particular purpose are disclaimed.
-- In no event shall the company or contributors be liable for any
-- direct, indirect, incidental, special, exemplary, or consequential
-- damages (including, but not limited to, procurement of substitute
-- goods or services; loss of use, data, or profits; or business
-- interruption) however caused and on any theory of liability, whether
-- in contract, strict liability, or tort (including negligence or
-- otherwise) arising in any way out of the use of this software, even
-- if advised of the possibility of such damage.
-- 
--      $Id$
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.std_logic_unsigned.all;
use work.configure.all;		-- my data types
use IEEE.NUMERIC_STD.ALL;

entity treshold_unit is
	port(
		CLK 		: in std_logic;
		RESET		: in std_logic;
		
		INDEX		: in std_logic_vector(3 downto 0);
		TRESHOLD	: in std_logic_vector(17 downto 0);
		FEATURE	: in std_logic_vector(8 downto 0);
		
		FIRST		: in std_logic;
		ENABLE	: in std_logic;
		
		DETECT	: out std_logic;
		SUMA_OUT	: out std_logic_vector(17 downto 0)
		
	);
end treshold_unit;

architecture Behavioral of treshold_unit is

type array_9x18b is array(9 downto 0) of std_logic_vector(17 downto 0);
signal acc			: array_9x18b;
signal next_acc	: array_9x18b;
signal next_detect : std_logic;
signal suma_next	: std_logic_vector(17 downto 0);

begin


SYNC_PROC: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (reset = '1') then
				for i in 0 to 9 loop
					acc(i) <= (others => '0');
				end loop;
				DETECT <= '0';
				SUMA_OUT <= (others => '0');
         else
				for i in 0 to 9 loop
					acc(i) <= next_acc(i);					
				end loop;
				DETECT <= next_detect;
				SUMA_OUT <= suma_next;
         end if;        
      end if;
   end process;
	
	
	
OUT_PROC: process ( FIRST, INDEX, acc, TRESHOLD, FEATURE, ENABLE)
		variable suma : std_logic_vector(17 downto 0);
	begin	
		for i in 0 to 9 loop
			next_acc(i) <= acc(i);
		end loop;
		next_detect <= '0';
		suma_next <= (others => '0');
		
		if ENABLE = '1' then	
			if FIRST = '1' then
				suma := "00"&X"1000";
			else
				suma := acc(conv_integer(INDEX));
			end if;		
			
			suma:= suma + FEATURE + ACC_ADD_VAL;
			suma_next <= suma;		
			
			next_acc(conv_integer(INDEX)) <= suma;
			
			if suma > TRESHOLD then
				next_detect <= '1';
			end if;
		end if;
	end process;
	

end Behavioral;

