//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/20                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class computing maximum curvature from Class for simulating Gauss function
 */

#include <OMToolkit\OMTypes.h>

namespace OMToolkit
{
	class OMMatrixCurvature
	{
		public:
			typedef Types::ModuleMeshd MeshT;
			typedef MeshT::Scalar ScalarT;
			typedef MeshT::Normal NormalT;
			typedef MeshT::AttributeScalar AScalarT;
			typedef Types::OMSerializableMatrix<AScalarT> MatrixT;
			enum MatrixType {MIN, MAX, MEAN, GAUSS};

			OMMatrixCurvature(MeshT *mesh);
			bool Compute(OpenMesh::VPropHandleT<MatrixT> matrixH, OpenMesh::VPropHandleT<NormalT> curvatureH, OpenMesh::VPropHandleT<AScalarT> curvatureMagH, MatrixType type = MAX);
		private:
			MeshT *m_mesh;
	};

	static OMMatrixCurvature::AScalarT sobelHoriz3x3[] = {	1.0,	0.0,	-1.0,	
															2.0,	0.0,	-2.0,
															1.0,	0.0,	-1.0	};
	
	static OMMatrixCurvature::AScalarT sobelVert3x3[] = {	1.0,	2.0,	1.0,	
															0.0,	0.0,	0.0,
															-1.0,	-2.0,	-1.0	};

	static OMMatrixCurvature::AScalarT sobelHoriz5x5[] = {	2.0,	1.0,	0.0,	-1.0,	-2.0, 
															3.0,	2.0,	0.0,	-2.0,	-3.0, 
															4.0,	3.0,	0.0,	-3.0,	-4.0, 
															3.0,	2.0,	0.0,	-2.0,	-3.0, 
															2.0,	1.0,	0.0,	-1.0,	-2.0	};

	static OMMatrixCurvature::AScalarT sobelVert5x5[] = {	2.0,	3.0,	4.0,	3.0,	2.0, 
															1.0,	2.0,	3.0,	2.0,	1.0, 
															0.0,	0.0,	0.0,	0.0,	0.0, 
															-1.0,	-2.0,	-3.0,	-2.0,	-1.0,  
															-2.0,	-3.0,	-4.0,	-3.0,	-2.0	};

	static OMMatrixCurvature::AScalarT sobelHoriz7x7[] = {	3.0,	2.0,	1.0,	0.0,	-1.0,	-2.0,	-3.0, 
															4.0,	3.0,	2.0,	0.0,	-2.0,	-3.0,	-4.0,
															5.0,	4.0,	3.0,	0.0,	-3.0,	-4.0,	-5.0,
															6.0,	5.0,	4.0,	0.0,	-4.0,	-5.0,	-6.0,
															5.0,	4.0,	3.0,	0.0,	-3.0,	-4.0,	-5.0,
															4.0,	3.0,	2.0,	0.0,	-2.0,	-3.0,	-4.0,
															3.0,	2.0,	1.0,	0.0,	-1.0,	-2.0,	-3.0	};

	static OMMatrixCurvature::AScalarT sobelVert7x7[] = {	3.0,	4.0,	5.0,	6.0,	5.0,	4.0,	3.0, 
															2.0,	3.0,	4.0,	5.0,	4.0,	3.0,	2.0,
															1.0,	2.0,	3.0,	4.0,	3.0,	2.0,	1.0,
															0.0,	0.0,	0.0,	0.0,	0.0,	0.0,	0.0,
															-1.0,	-2.0,	-3.0,	-4.0,	-3.0,	-2.0,	-1.0,
															-2.0,	-3.0,	-4.0,	-5.0,	-4.0,	-3.0,	-2.0,
															-3.0,	-4.0,	-5.0,	-6.0,	-5.0,	-4.0,	-3.0	};

	static OMMatrixCurvature::AScalarT sobelHoriz9x9[] = {	4.0,	3.0,	2.0,	1.0,	0.0,	-1.0,	-2.0,	-3.0,	-4.0,
															5.0,	4.0,	3.0,	2.0,	0.0,	-2.0,	-3.0,	-4.0,	-5.0,
															6.0,	5.0,	4.0,	3.0,	0.0,	-3.0,	-4.0,	-5.0,	-6.0,
															7.0,	6.0,	5.0,	4.0,	0.0,	-4.0,	-5.0,	-6.0,	-7.0,
															8.0,	7.0,	6.0,	5.0,	0.0,	-5.0,	-6.0,	-7.0,	-8.0,
															7.0,	6.0,	5.0,	4.0,	0.0,	-4.0,	-5.0,	-6.0,	-7.0,
															6.0,	5.0,	4.0,	3.0,	0.0,	-3.0,	-4.0,	-5.0,	-6.0,
															5.0,	4.0,	3.0,	2.0,	0.0,	-2.0,	-3.0,	-4.0,	-5.0,
															4.0,	3.0,	2.0,	1.0,	0.0,	-1.0,	-2.0,	-3.0,	-4.0	};

	static OMMatrixCurvature::AScalarT sobelVert9x9[] = {	4.0,	5.0,	6.0,	7.0,	8.0,	7.0,	6.0,	5.0,	4.0,
															3.0,	4.0,	5.0,	6.0,	7.0,	6.0,	5.0,	4.0,	3.0,
															2.0,	3.0,	4.0,	5.0,	6.0,	5.0,	4.0,	3.0,	2.0,
															1.0,	2.0,	3.0,	4.0,	5.0,	4.0,	3.0,	2.0,	1.0,
															0.0,	0.0,	0.0,	0.0,	0.0,	0.0,	0.0,	0.0,	0.0,
															-1.0,	-2.0,	-3.0,	-4.0,	-5.0,	-4.0,	-3.0,	-2.0,	-1.0,
															-2.0,	-3.0,	-4.0,	-5.0,	-6.0,	-5.0,	-4.0,	-3.0,	-2.0,
															-3.0,	-4.0,	-5.0,	-6.0,	-7.0,	-6.0,	-5.0,	-4.0,	-3.0,
															-4.0,	-5.0,	-6.0,	-7.0,	-8.0,	-7.0,	-6.0,	-5.0,	-4.0	};
	}