//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/25                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Module description:
 * - Module starts an OSG viewer and shows model, which is in input MDSTk channel
 */

#ifndef _OM_VIEWER_H_
#define _OM_VIEWER_H_


#include <MDSTk\Module\mdsModule.h>

/**
 * Module which loads a mesh from input MDSTk channel, converts it into osg::geometry and runs a viewer
 */
class OMViewer : public mds::mod::CModule
{
	public:
		/**
		 * Smart pointer type
		 */
		MDS_SHAREDPTR(OMViewer);

		/**
		 * Constructor
		 * @param sDescription Description of the module
		 */
		OMViewer(const std::string& sDescription);

		/**
		 * Virtual destructor
		 */
		virtual ~OMViewer();

	protected:
		/**
		 * Virtual method called on startup
		 * @returns True if startup was successful
		 */
		virtual bool startup();

		/**
		 * Virtual method called by the processing thread
		 * @returns True if main loop continues
		 */
		virtual bool main();

		/**
		 * Called on console shutdown
		 */
		virtual void shutdown();

		/**
		 * Called on writing a usage statement
		 * @param Stream Output stream
		 */
		virtual void writeExtendedUsage(std::ostream& Stream);

		/**
		 * Visualisation
		 */
		std::string m_visualisation;

		/**
		 * Visualisation ommit
		 */
		double m_ommit;

		/**
		 * Directions visualisation
		 */
		std::string m_directions;

		/**
		 * Lenght of showed normals;
		 */
		double m_normal_lenght;

		/**
		 * Vector component to visualise
		 */
		int m_vector_component;
};

/**
 * Smart pointer to console application
 */
typedef OMViewer::tSmartPtr    OMViewerPtr;

#endif // _OM_VIEWER_H_