//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/27                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Module description:
 * - Module loads a file from input channel
 * - Then, subdivides a mesh in specified number of iterations
 * - Result is written into output channel
 */

#ifndef _OM_SUBDIVIDE_MESH_H_
#define _OM_SUBDIVIDE_MESH_H_

#include <MDSTk/Module/mdsModule.h>

/**
 * Module subdivides mesh wit use of one of implemented methods
 * Possible methods are: Loop, Composite Loop, Sqrt3, Composite Sqrt3
 */
class OMSubdivideMesh : public mds::mod::CModule
{
	public:
		/**
		 * Smart pointer type
		 */
		MDS_SHAREDPTR(OMSubdivideMesh);

		/**
		 * Constructor
		 * @param sDescription Description of the module
		 */
		OMSubdivideMesh(const std::string& sDescription);

		/**
		 * Virtual destructor
		 */
		virtual ~OMSubdivideMesh();

	protected:
		/**
		 * Virtual method called on startup
		 * @returns True if startup was successful
		 */
		virtual bool startup();

		/**
		 * Virtual method called by the processing thread
		 * @returns True if main loop continues
		 */
		virtual bool main();

		/**
		 * Called on console shutdown
		 */
		virtual void shutdown();

		/**
		 * Called on writing a usage statement
		 * @param Stream Output stream
		 */
		virtual void writeExtendedUsage(std::ostream& Stream);

		/**
		 * Subdivision method
		 */
		std::string m_method;

		/**
		 * Number of iterations
		 */
		int m_iterations;
};

/**
 * Smart pointer to console application
 */
typedef OMSubdivideMesh::tSmartPtr    OMSubdivideMeshPtr;

#endif // _OM_SUBDIVIDE_MESH_H_