//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/20                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class representing a ray in raycasting procedure
 */

#ifndef OM_BSP_TREE_RAY_H
#define OM_BSP_TREE_RAY_H

#include <OMToolkit\OMTypes.h>

namespace OMToolkit
{
	/**
	 * Class representing a ray
	 */
	class OMRay : OMToolkit::Types::ModuleMeshd::Point
	{

		public:
			typedef OMToolkit::Types::ModuleMeshd::Point PointT;

			/**
			 * Constructor - initializes ray information and precomputes some data
			 */
			OMRay(PointT &origin, PointT &direction)
			{
				m_origin = origin;
				m_direction = direction;
				m_inv_dir = PointT(1.0f/direction[0], 1.0f/direction[1], 1.0f/direction[2]);
				m_posneg[0] = m_direction[0] > 0 ? 0 : 1;
				m_posneg[1] = m_direction[1] > 0 ? 0 : 1;
				m_posneg[2] = m_direction[2] > 0 ? 0 : 1;
			}

			/**
			 * Ray's origin
			 */
			PointT m_origin;

			/**
			 * Ray's vector
			 */
			PointT m_direction;

			/**
			 * Ray's inverse vector (1/vector)
			 */
			PointT m_inv_dir;

			/**
			 * Number saying, if vector coordinate is negative or not
			 */
			unsigned int m_posneg[3];
	};
}

#endif