//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/23                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class derrived from OpenMesh OM writer
 * - Extends functionality for export into MDSTk Channel
 * - Most of code is modified OpenMesh
 */

#ifndef _OM_WRITER_EXT_H_
#define _OM_WRITER_EXT_H_

#include <OpenMesh\Core\IO\writer\OMWriter.hh>
#include <OMToolkit/IO\OMFormatExt.h>
#include <strstream>

namespace OpenMesh {
namespace IO {

/**
 * Class extends functionality of OMWriter for export into MDSTk Channel
 */
class OMWriterExt : public _OMWriter_
{
	public:
		/**
		 * Method writes a mesh into MDSTk Channel
		 * @param _os Output MDSTk channel
		 * @param _be Base exporter used for writing
		 * @param _opt Options used for writing
		 * @return True, if all was successfully written
		 */
		bool write(mds::mod::CChannel& _os, BaseExporter& _be, Options _opt) const;

	protected:
		/**
		 * Method writes a mesh into binary MDSTk Channel
		 * @param _os Output MDSTk channel
		 * @param _be Base exporter used for writing
		 * @param _opt Options used for writing
		 * @return True, if all was successfully written
		 */
		bool write_binary(mds::mod::CChannel& _os, BaseExporter& _be, Options _opt) const;
 
		/**
		 * Method writes a custom property into MDSTk channel
		 * @param _os Output MDSTk channel
		 * @param _bp Base property used for writing
		 * @param _entity Entity to save
		 * @param _swap Swap byte flag
		 * @return Number of successfully written bytes
		 */
		size_t store_binary_custom_chunk(mds::mod::CChannel& _os, const BaseProperty& _bp, OMFormat::Chunk::Entity _entity, bool _swap) const;
};

} // namespace IO
} // namespace OpenMesh

#endif