//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/20                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class for Visualizing color legend
 */

#ifndef _OM_LEGENDGEO_H_
#define _OM_LEGENDGEO_H_

#include <osg/MatrixTransform>
#include <osg/Projection>

#include <osg/Matrix>
#include <osg/Geode>
#include <osg/Geometry>
#include <osgText/Text>
#include <OMToolkit/OMVisualiser.h>

#include <OpenMesh\Tools\Utils\Timer.hh>
#include <OMToolkit\OMErrorLog.h>
#include <MDSTk\Base\mdsGlobalLog.h>
#include <OpenMesh\Core\IO\exporter\ExporterT.hh>
#include <OMToolkit\OMTypes.h>

#include <osg/Geometry>

namespace osg
{
	/**
	 * Legend size (lenght)
	 */
	const int HUD_SIZE = 200;

	/**
	 * Legend distance from screen corners
	 */
	const int HUD_MARGIN = 20;

	/**
	 * Legend bar height
	 */
	const int HUD_HEIGHT = 20;

	/**
	 * Number of texts
	 */
	const int TEXT_SIZE = 3;

	/**
	 * Text size (char size)
	 */
	const int TEXT_CHAR = 9;

	/**
	 * Class inheriting osg geometry, in constructor, we must specify window size and minimum and maximum values for legend
	 */
	class OMLegendGeometry : public Geometry
	{
		public:
			/**
			 * Constructor
			 * @param min Minimum value showed in legend
			 * @param max Maximum value showed in legend
			 * @param windowHeight Height of HUD window
			 * @param windowWidth Height of HUD window
			 */
			OMLegendGeometry(double min, double max, int windowHeight, int windowWidth);

			/**
			 * Function registers this geometry into osg Group (with all the setup matrices)
			 * @param parent OSG root group
			 */
			void addToGroup(osg::ref_ptr<osg::Group> parent);

	private:
			/**
			 * Width intern variable
			 */
			int m_width;

			/**
			 * Height intern variable
			 */
			int m_height;

			/**
			 * Texts to show
			 */
			ref_ptr<osgText::Text> text[TEXT_SIZE];
		}; // class OMLegendGeo
} // namespace osg
#endif