//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/25                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Module description:
 * - Module reads a file specified in -file argument
 * - Result is sent to connected MDSTk channel
 */

#ifndef _OM_LOAD_FILE_H_
#define _OM_LOAD_FILE_H_

#include <MDSTk/Module/mdsModule.h>

/**
 * Module which loads a mesh from input fule and send it to connected MDSTk channel
 * Possible file formats are .stl, .om, .obj, .off, .ply
 */
class OMLoadFile : public mds::mod::CModule
{
	public:
		/**
		 * Smart pointer type
		 */
		MDS_SHAREDPTR(OMLoadFile);

		/**
		 * Constructor
		 * @param sDescription Description of the module
		 */
		OMLoadFile(const std::string& sDescription);

		/**
		 * Virtual destructor
		 */
		virtual ~OMLoadFile();

	protected:
		/**
		 * Virtual method called on startup
		 * @returns True if startup was successful
		 */
		virtual bool startup();

		/**
		 * Virtual method called by the processing thread
		 * @returns True if main loop continues
		 */
		virtual bool main();

		/**
		 * Called on console shutdown
		 */
		virtual void shutdown();

		/**
		 * Called on writing a usage statement
		 * @param Stream Output stream
		 */
		virtual void writeExtendedUsage(std::ostream& Stream);

		double m_deviation;
		int m_size;
		bool m_normalize;
};

/**
 * Smart pointer to console application
 */
typedef OMLoadFile::tSmartPtr    OMLoadFilePtr;

#endif // _OM_LOAD_FILE_H_