﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using UnityEngine.UI;

public class RoadGenerator : MonoBehaviour {

	public TextAsset mRoadPointsCSV;
	public TextAsset mRoadTraffic;
	public GameObject roadPoint;
	public Slider hSlider;
	public int roadScale = 10;

	private List<Vector2> roadPoints;
	private int cTime;
	private GameObject[] groundPoints;
	private bool showHistory;

	// Use this for initialization
	void Start () {
		roadPoints = new List<Vector2> ();
		var roadPointsLines = mRoadPointsCSV.text.Split("\n"[0]);
		for (var i = 0; i < roadPointsLines.Length; i++) {
			string[] coordinates = roadPointsLines[i].Split(","[0]);
			if(coordinates.Length < 2) {
				continue;
			}
			float x = float.Parse(coordinates[0]);
			float y = float.Parse (coordinates[1]);
			roadPoints.Add(new Vector2(x, y));

		}
		this.tag = "road";

		groundPoints = new GameObject[roadPoints.Count];

		for(int i = 0; i < roadPoints.Count; i++) {
			Vector2 point = roadPoints[i];
			//Vector2 pointPrev = roadPoints[i-1];

			GameObject obj = (GameObject) Instantiate(roadPoint);
			obj.transform.parent = this.gameObject.transform;
			obj.transform.localScale = new Vector3(roadScale, roadScale, roadScale);
			obj.transform.localPosition = new Vector3(point.x, 0, point.y);

			if(i > 0) {
				LineRenderer lr = obj.GetComponent<LineRenderer>();
				Vector2 prevPoint = roadPoints[i-1];
				Vector2 diff = (prevPoint - point)*(1.0f/roadScale);
			
				lr.SetWidth(roadScale*2/3, roadScale*2/3);
				lr.SetVertexCount(2);
				lr.SetPosition(0, new Vector3(0, -0.5f, 0));
				lr.SetPosition(1, new Vector3(diff.x, -0.5f, diff.y));

				/*
				lr.SetPosition(0, new Vector3(pointPrev.x, 0, pointPrev.y));
				lr.SetPosition(1, new Vector3(point.x, 0, point.y));
				*/
			
			}
			obj.AddComponent<TouchEvents>();
			obj.AddComponent<BoxCollider>();
			BoxCollider coll = obj.GetComponent<BoxCollider>();
			coll.size = new Vector3(20/roadScale, 20/roadScale, 20/roadScale);
			groundPoints[i] = obj;
		}
	
		reload();
		//generateHistory ();
	}

	private void reload()
	{
		cTime = (int)hSlider.value;
		int[] traffic = getTraffic (cTime);
		TrafficMaterials mats = this.GetComponent<TrafficMaterials>();
		
		
		for(int i = 0; i < groundPoints.Length; i++) {

			if(i < traffic.Length) {
				groundPoints[i].GetComponent<MeshRenderer>().material = mats.getTrafficState(traffic[i]);
				//LineRenderer lr = groundPoints[i].GetComponent<LineRenderer>();
				//lr.material = mats.getTrafficState(traffic[i]);
				if(i > 0) {
					Color p = mats.getTrafficState(traffic[i]).color;
					LineRenderer lr = groundPoints[i].GetComponent<LineRenderer>();
					lr.enabled = true;
					lr.material.color = p;
				}
			}
		}
	}
	
	// Update is called once per frame
	void Update () {
		if (cTime != hSlider.value) {
			reload ();
			if(showHistory) {
				generateHistory();
			}
		}
	}

	private int[] getTraffic(int time)
	{
		string currentTraffic = mRoadTraffic.text.Split ("\n" [0]) [time];
		string[] trafficStateStrings = currentTraffic.Split ("," [0]);
		int[] trafficStateInts = new int[trafficStateStrings.Length];
		for (int i = 0; i < trafficStateStrings.Length; i++) {
			trafficStateInts[i] = int.Parse(trafficStateStrings[i]);
		}
		return trafficStateInts;
	}

	public void ShowHistory(bool show)
	{
		this.showHistory = show;
		if (show) {
			generateHistory ();
		} else {
			hideHistory();
		}
	}

	public bool isHistoryVisible()
	{
		return this.showHistory;
	}

	public void ToggleHistory()
	{
		this.ShowHistory(!this.showHistory);
	}

	private void hideHistory()
	{
		GameObject[] prev = GameObject.FindGameObjectsWithTag ("history");
		for(int i = 0; i < prev.Length; i++) 
		{
			Destroy(prev[i]);
		}
	}

	public void generateHistory()
	{
		TrafficMaterials mats = this.GetComponent<TrafficMaterials>();
		hideHistory ();
		int histLength = 8;


		for (int histTime = 1; histTime < histLength; histTime++)
		{
			Material[] transparentMaterials = new Material[6];
			for(int i = 0; i < 6; i++)
			{
				transparentMaterials[i] = Instantiate(mats.getTrafficState(i)) as Material;
				Color p = transparentMaterials[i].color;
				p.a = (histLength - histTime)/8.0f;
				transparentMaterials[i].color = p;
			}
			int[] traffic = getTraffic( (cTime + 24 + histTime) % 24);

			for(int i = 0; i < roadPoints.Count; i++) {
				Vector2 point = roadPoints[i];
				GameObject obj = (GameObject) Instantiate(roadPoint);
				obj.transform.parent = this.gameObject.transform;
				obj.transform.localScale = new Vector3(roadScale, roadScale, roadScale);
				obj.transform.localPosition = new Vector3(point.x, +histTime*16, point.y);
				obj.tag = "history";
				obj.GetComponent<LineRenderer>().enabled = false;


				if(i < traffic.Length) {
					obj.renderer.material = transparentMaterials[traffic[i]];
				}
			}
		}
	}
}
