﻿using UnityEngine;
using System.Collections;

public class TouchEvents : MonoBehaviour {
	
	void OnMouseDown() {
		GameObject roadX = transform.parent.gameObject;


		GameObject[] roads = GameObject.FindGameObjectsWithTag ("road");
		foreach (GameObject obj in roads)
		{
			if(!obj.Equals(roadX)) {
				RoadGenerator comp = obj.GetComponent<RoadGenerator>();
				comp.ShowHistory(false);
			}
		}





		if (roadX != null) {
			RoadGenerator comp = roadX.GetComponent<RoadGenerator>();
			comp.ToggleHistory();

			GameObject highlight = GameObject.FindGameObjectWithTag ("highlight");

			if (highlight != null && !comp.isHistoryVisible())
			{
				highlight.transform.parent = this.gameObject.transform;
				highlight.transform.localPosition = new Vector3(0, 0, 0);
				highlight.transform.localScale = new Vector3(2, 2, 2);
				TextMesh tm = highlight.GetComponentInChildren<TextMesh>();
				tm.text = "Current avg speed: 48 km/h\n" +
					"Traffic: moderate";
			} else {
				highlight.transform.localScale = new Vector3(0.0001f, 0.0001f, 0.0001f);
			}
		}

	}
}
