/*	ArgumentParser C++: easy and lightweight header library
    Copyright (C) 2015  Jan Brejcha

    OPEN SOURCE LICENCE VUT V BRNĚ
	Verze 1.
	Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
	-------------------------------------------------------------------------------
*/

#ifndef PARAMETER
#define PARAMETER

#include <string>

using namespace std;

namespace argpar {

struct Parameter {
    string name;
    string description;
    bool list;

    /**
     * @brief Parameter
     * @param _name
     * @param _description
     * @param _list If true, then this parameter represents list of parameters
     *              of infinity length. Only last parameter of an argument
     *              can be defined as list.
     */
    Parameter(string _name, string _description, bool _list=false)
        :name(_name), description(_description), list(_list)
    {
    }
};

}

#endif // PARAMETER

