/**
 * BOWQueryResult.h
 *
 *  Created on: Nov 21, 2014
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef PROJECTS_RELIEF_PANO_SRC_HORIZON_LOCATE_HLOC_BOWQUERYRESULT_H_
#define PROJECTS_RELIEF_PANO_SRC_HORIZON_LOCATE_HLOC_BOWQUERYRESULT_H_

#include <algorithm>

#include "DatabaseEntry.h"

class BOWQueryResult {
public:
	/**
	 * Initializer of the BOWQueryResult
	 *
	 * @param query		the query to which the result is connected.
	 * @param maxSize	maximum size of the result
	 */
	BOWQueryResult(DatabaseEntry query, int maxSize = 50);

	/**
	 * Adds new entry into the result.
	 *
	 *
	 * @param distance 		the distance from query entry
	 * @param de			the document number from the database
	 */
	void addEntry(float distance, int de);

	/**
	 * Get the const iterator to begin of the result.
	 */
	std::vector< float >::const_iterator begin();

	/**
	 * Get the const iterator to end of the result.
	 */
	std::vector< float >::const_iterator end();

	DatabaseEntry getQuery();

	void print();

	int operator [] (const int i);

	int size();


private:

	/**
	 * Vector storing pairs, first is distance of entry from query,
	 * second is the entry.
	 *
	 * key is the document number, value is the distance of this document
	 * from query
	 */
	std::vector< float > results;

	/**
	 * The query thanks to which the result was generated.
	 */
	DatabaseEntry query;


	void removeRedundantEntries();

};

#endif /* PROJECTS_RELIEF_PANO_SRC_HORIZON_LOCATE_HLOC_BOWQUERYRESULT_H_ */
