/**
 *  LocalFeature.h
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#ifndef LOCAL_FEATURE
#define LOCAL_FEATURE

#include "Persistable.h"

/**
 * Abstract LocalFeature class.
 * this abstract representation of feature is used in BagOfWords implementation.
 */
class LocalFeature : public Persistable {

public:
    /**
     * Get the ID of the local feature for BagOfWords.
     */
    inline virtual int featureId() const { return 0; }

    /**
      * Get the ID of the local feature for BagOfWords with paked direction.
      */
     inline virtual int pFeatureId() const { return 0; }

    /**
     * LocalFeature has to define < operator to be sortable using std::sort().
     */
    virtual bool operator < (const LocalFeature &other) const
    {
    	return (featureId() < other.featureId());
    }

    /**
	 * Converts the object into XMLElement of QtXML library
	 */
	virtual QDomElement toXMLElement(QDomDocument &doc) = 0;

	/**
	 * Initializes the object from XMLElement of QtXML library
	 */
	virtual void initFromXMLElement(QDomElement &e) = 0;

	virtual void initWithXmlStreamReader(QXmlStreamReader &xml) = 0;

    virtual void saveToXmlStream(QXmlStreamWriter &xml) = 0;


};

#endif

