/**
 *  BOWQueryResult.cpp
 *
 *  Created on: Nov 21, 2014
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "BOWQueryResult.h"

BOWQueryResult::BOWQueryResult(DatabaseEntry query, int maxSize)
: query(query)
{
	results = std::vector< float >(maxSize);
}


/*void BOWQueryResult::addEntry(double distance, DatabaseEntry de)
{
	std::pair<double, DatabaseEntry > entry(distance, de);
	results.push_back(entry);
}*/

void BOWQueryResult::addEntry(float distance, int de)
{
	results[de] = distance;
}

DatabaseEntry BOWQueryResult::getQuery()
{
	return query;
}

std::vector< float >::const_iterator
BOWQueryResult::begin()
{
	return results.begin();
}

std::vector< float >::const_iterator
BOWQueryResult::end()
{
	return results.end();
}

int BOWQueryResult::operator [] (const int i)
{
	return results[i];
}
int BOWQueryResult::size()
{
	return results.size();
}


void BOWQueryResult::print()
{
	/*for (std::map< double, std::vector<DatabaseEntry> >::iterator it = results.begin();
			it != results.end(); ++it)
	{
		for (std::vector<DatabaseEntry>::iterator vit = it->second.begin();
				vit != it->second.end(); ++vit)
		{
			printf("%s, distance: %f\n", vit->key.toStdString().c_str(), it->first);
		}
	}*/
}
