/**
 *  Contourlett.h
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "Contourlett.h"
#include <QDebug>
#include <iostream>
#include <QFile>
#include <QTextStream>

Contourlett::Contourlett(double *horizonLine, int _pause, int start, int alpha)
{
	feature_id = 0;

    for (int i = 0; i < 8; ++i)
    {
    	int index = (i * _pause) + start;
    	data[i] = horizonLine[index];
    	//printf("horizonLine: %f, data: %f, index: %d, i: %d\n", horizonLine[index], data[i], index, i);
    }



	//printf("pause: %d, start: %d\n", _pause, start);
	/*for (int i = 0; i < CONTOURLETT_SAMPLES; ++i)
	{
		printf("%f ", data[i]);
	}
	printf("\n");*/

    //normalize
    this->normalize(_pause);
    //quantize and calculate feature_id
    this->quantize();

	//encode alpha to feature id

	int foo = Contourlett::packDirection(feature_id, alpha);

	//printf("raw fid: %d, alpha: %d, fId: %d\n", feature_id, alpha, foo);


	feature_id = foo;
}


void Contourlett::normalize(int pause)
{
    //calculate mean value
    long sum = 0;
    int w = CONTOURLETT_SAMPLES;
    
    for (int i = 0; i < w; ++i)
    {
        sum += data[i];
    }
    double mean = sum / (double) w;
    /*QString fea_name = pause < 10 ? "hloc_fea_2.txt" : "hloc_fea_10.txt";*/
    //double denom = pause < 10 ? 8 : pause;
    double denom = pause+3;
    //double denom = pause;
    /*QFile fea_file(fea_name);
    if (fea_file.open(QIODevice::WriteOnly | QIODevice::Append))
    {
        QTextStream fea_out(&fea_file);
        for (int i = 0; i < w; ++i)
        {
            fea_out << (data[i] - mean) << " ";
        }
        fea_out << endl;
        fea_file.close();
    }*/

    //normalize (y_i - mean)/w
    //double denom = pause;
    //double denom = (double)w;
    //std::cout << denom << std::endl;
    for (int i = 0; i < w; ++i)
    {
        data[i] = (data[i] - mean) / denom;
    }
}

void Contourlett::quantize()
{
	//calculate min, max
	/*double min = INT_MAX;
	double max = INT_MIN;
	for (int i = 0; i < CONTOURLETT_SAMPLES; ++i)
	{
		if (data[i] < min)
			min = data[i];
		if (data[i] > max)
			max = data[i];
	}*/
	double min = -1.5;
	double max = 1.5;
	//calculate shift (e.g. number of digits when bin number
	//considered as a binary number)
	int shift = (int)log2(BIN_COUNT);
	double binsize = double(max - min) / BIN_COUNT;
	for (int i = 0; i < CONTOURLETT_SAMPLES; ++i)
	{
		int bin = 0;

		for (int j = 0; j < BIN_COUNT; ++j)
		{
			//start of current bin
			double sbin = min + (j * binsize);
			//end of current bin
			double ebin = sbin + binsize;

			//lowest bin -> minus inf
			if (sbin == min && data[i] < min)
			{
				bin = j; //which is 0
				break;
			}
			//greatest bin -> plus inf
			if (j == (BIN_COUNT - 1) && data[i] > max)
			{
				bin = j; //which is 7
				break;
			}
			//to which bin the current dimension falls?
			//this if is ambiguos, but thanks to the break the dimension
			//will fall into the first bin found, which is correct.
			if (data[i] >= sbin && data[i] <= ebin)
			{
				bin = j;
				break;
			}
		}
		//calculate feature id
		feature_id = feature_id | (bin << (shift * i));
	}
}

int Contourlett::packDirection(int feature_id, int alpha)
{
	int alpha_bin = alpha / 3;
	//int shift = (int)log2(BIN_COUNT);
	return feature_id | (alpha_bin << 24);
}

int Contourlett::unpackDirection(int feature_id)
{
	//int shift = (int)log2(BIN_COUNT);
	return ((feature_id & 4278190080) >> 24)*3;
}

int Contourlett::unpackFeatureId(int feature_id)
{
	return (feature_id & 16777215);
}

void Contourlett::print()
{
	for (int i = 0; i < CONTOURLETT_SAMPLES; ++i)
	{
		printf("%f ", data[i]);
	}
	printf("\n");
}

QDomElement Contourlett::toXMLElement(QDomDocument &doc)
{
	QDomElement c = doc.createElement("c_id");
	QDomText id = doc.createTextNode(QString::number(feature_id));
	c.appendChild(id);
	return c;
}

void Contourlett::saveToXmlStream(QXmlStreamWriter &xml)
{
    xml.writeTextElement("c_id", QString::number(feature_id));
}

void Contourlett::initFromXMLElement(QDomElement &e)
{
	QDomNode n = e.firstChild();
	if (!n.isNull())
	{
		QDomText id_dom = n.toText();
		if (!id_dom.isNull())
		{
			//Contourlett obtained, create it
			feature_id = id_dom.nodeValue().toInt();
		}
	}
}

void Contourlett::initWithXmlStreamReader(QXmlStreamReader &xml)
{
	if (xml.isStartElement() && xml.name() == "c_id")
	{
		this->feature_id = xml.readElementText().toInt();
		//qDebug() << "loading feature: " << this->feature_id;
	}
}


int Contourlett::initWithXmlStreamReader(xmlTextReaderPtr &reader)
{
    const xmlChar *name, *value;
    int ret = -1;
    name = xmlTextReaderLocalName(reader);
    int type = xmlTextReaderNodeType(reader);

    if (name != NULL
            && strcmp((const char *)name, "c_id") == 0
            && type == XML_READER_TYPE_ELEMENT)
    {
        //get from <c_id> node to text node
        ret = xmlTextReaderRead(reader);
        //retrieve value of text node
        value = xmlNodeGetContent(xmlTextReaderCurrentNode(reader));
        if (value != NULL)
        {
            this->feature_id = atoi((const char *)value);
            xmlFree((void *)value);
            value = NULL;
        }
        xmlFree((void *)name);
        name = NULL;
        //read ending node
        ret = xmlTextReaderRead(reader);
    }
    return ret;
}

