/**
 *  stringzip.cpp
 *
 *  Created on:   2016-05-04T07:45:06+02:00
 *  Author: Jan Brejcha <ibrejcha@fit.vutbr.cz>, <brejchaja@gmail.com>
 *  Copyright (C) 2014  Jan Brejcha
 *
 *  OPEN SOURCE LICENCE VUT V BRNĚ
 *  Verze 1.
 *  Copyright (c) 2010, Vysoké učení technické v Brně, Antonínská 548/1, PSČ 601 90
 *  -------------------------------------------------------------------------------
 */

#include "stringzip.h"

StringZip::StringZip(ByteArray &str_to_zip)
{
    size = str_to_zip.size();
    str = new char[size];
    memcpy(str, str_to_zip.getData(), sizeof(char) * size);
}

StringZip::~StringZip()
{
    delete str;
    str = NULL;
}

ByteArray StringZip::zip()
{
    z_stream defstream;
    defstream.zalloc = Z_NULL;
    defstream.zfree = Z_NULL;
    defstream.opaque = Z_NULL;
    uInt insize = size;

    char *result = (char *)malloc(sizeof(char) * insize);

    defstream.avail_in = insize; // size of input, string + terminator
    defstream.next_in = (Bytef *)str; // input char array
    defstream.avail_out = insize; // size of output
    defstream.next_out = (Bytef *)result; // output char array

    deflateInit(&defstream, Z_BEST_COMPRESSION);
    int state = deflate(&defstream, Z_FINISH);
    int i = 1;
    int used = insize - defstream.avail_out;

    while (state == Z_OK && defstream.avail_out == 0)
    {
        //not all have been produced,
        //continue reading to output buffer
        result = (char *)realloc(result, (++i) * (sizeof(char) * insize));
        defstream.avail_out = insize;
        defstream.next_out = (Bytef *)(result + ((i-1) * insize));
        state = deflate(&defstream, Z_FINISH);
        used += insize - defstream.avail_out;
    }
    if (state == Z_STREAM_END)
    {
        deflateEnd(&defstream);
    }
    else if (state == Z_STREAM_ERROR)
    {
        throw std::runtime_error("Unable to zip zip string.");
    }

    ByteArray result_str(result, used);
    free(result); result = NULL;
    return result_str;
}

std::string StringZip::unzip()
{
    z_stream defstream;
    defstream.zalloc = Z_NULL;
    defstream.zfree = Z_NULL;
    defstream.opaque = Z_NULL;
    uInt insize = size;

    char *result = (char *)malloc(sizeof(char) * insize);
    defstream.avail_in = insize; // size of input, string + terminator
    defstream.next_in = (Bytef *)str; // input char array
    defstream.avail_out = insize; // size of output
    defstream.next_out = (Bytef *)result; // output char array

    // the actual compression work.
    inflateInit(&defstream);
    int state = inflate(&defstream, Z_NO_FLUSH);
    int i = 1;
    while (state == Z_OK)
    {
        //not all have been produced,
        //continue reading to output buffer
        result = (char *)realloc(result, (++i) * (sizeof(char) * insize));
        defstream.avail_out = insize;
        defstream.next_out = (Bytef *)(result + (i-1) * insize);
        state = inflate(&defstream, Z_NO_FLUSH);
    }
    if (state == Z_STREAM_END)
    {
        inflateEnd(&defstream);
    }
    else if (state == Z_STREAM_ERROR)
    {
        throw std::runtime_error("Unable to unzip zip string.");
    }
    else if (state == Z_DATA_ERROR)
    {
        throw std::runtime_error("Unable to unzip zip string - corrupted data.");
    }

    std::string result_str((const char *)result);
    free(result); result = NULL;
    return result_str;
}
