/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

//============================================================
//				DEBUGGER INTERFACE VARIABLES AND FUNCTIONS
//============================================================
#ifndef SIM_DBG_H_
#define SIM_DBG_H_

#include "res_decls.h"
#include <vector>

// TODO: the library has to work in two modes:
// the first one is the mode of local debugger; the simulation is running on the single PC and the application is localy debugged (using commands from command line (stdin))
// the second one is the mode of remote debugger, which receives and sends debugging commands (and infos) into the middle ware
// 
/* Based on the selected mode the debugging library needs appropriate parameters (some type of structure, 
 * which enables to communicate with middle ware - for the whole simulator exists only one instance of this structure 
 * and all libraries communicate with middleware through this instance - the library solves requests' queuing 
 * from differents sources [libraries] - the sequential requests from one library are expected)
 * Note: The library is for example the debugger library, the statistic library, etc. */

// TODO: mas: 011106 - is this define necessary?
//#define RUN_DBG

//structure containing info about program breakpoints
struct TBreakpoint {
public:
	unsigned int addr;
	bool active;
	
	TBreakpoint();
	TBreakpoint(unsigned int a, bool act);
};

// class of ISAC debugger
class DbgL
{
	unsigned int *m_fast_progc;		// program counter for faster compiled simulator
	ISACTMapFastSim *m_fast_memmap;	// memory map for faster compiled simulator
	TRegister *m_slow_progc;			// program counter for slower compiled simulator 
	ISACTMapSlowSim *m_slow_memmap;	// memory map for slower compiled simulator
	bool m_halt;
public:
	int m_tsim;
	bool dbgl_was_change;
	bool dbg_debug;
	bool dbg_sim_running;
	bool dbg_instr_steping;
	bool dbg_subinstr_steping;
	bool dbg_instr_pause;
	bool dbg_subinstr_pause;
	bool was_change;
	
	// mas: 011106
	// TODO: use map instead of vector -> for map use this relation - (adress,Breakpoint)
	vector<TBreakpoint> dbg_breakpoints;
	vector<TBreakpoint> dbg_watchpoints;
	
//	TStat _csrettstat;
//	string _csretstr;	
public:
	DbgL(ISACTMap *pmmap, void *icounter, int tsim);
	
	bool is_breakpoint();
	bool is_watchpoint();
	
	void set_halt(bool haltval);	
	bool get_halt();	
};

/*extern bool dbgl_was_change;
*/

#define DBG_INSTR_STEPING \
	if (dbg_obj()->dbg_instr_steping) {\
		dbg_obj()->dbg_instr_pause = true;}
		
#define DBG_SUBINSTR_STEPING \
	if (dbg_obj()->dbg_subinstr_steping) {\
		dbg_obj()->dbg_subinstr_pause = true;}
	
/*
#define DBG_INSTR_PAUSE \
	if (dbg_instr_pause) {\
		if (dbg_instr_steping) dbg_step(); else dbg_pause(); \
		while (dbg_instr_pause);}

#define DBG_SUBINSTR_PAUSE \
	if (dbg_subinstr_pause) {\
		if (dbg_subinstr_steping) dbg_substep(); else dbg_pause();\
		while (dbg_subinstr_pause);}
*/
#ifdef RUN_DBG
#define DBG_INSTR_PAUSE \
	if (dbg_obj()->dbg_instr_pause) {\
		if (dbg_obj()->dbg_instr_steping) dbg_step(); else dbg_pause(); \
		dbg_pause_commands();\
		dbg_obj()->dbg_instr_pause = false; }

#define DBG_SUBINSTR_PAUSE \
	if (dbg_obj()->dbg_subinstr_pause) {\
		if (dbg_obj()->dbg_subinstr_steping) dbg_substep(); else dbg_pause();\
		dbg_obj()->dbg_pause_commands();\
		dbg_obj()->dbg_subinstr_pause = false; }
#else

#define DBG_INSTR_PAUSE 
#define DBG_SUBINSTR_PAUSE 

#endif


/*extern bool dbg_debug;
extern bool dbg_sim_running;
extern bool _halt;
extern bool dbg_instr_steping;
extern bool dbg_subinstr_steping;
extern bool dbg_instr_pause;
extern bool dbg_subinstr_pause;

extern vector<TBreakpoint> dbg_breakpoints;
extern vector<TBreakpoint> dbg_watchpoints;*/

//initializes debugging variables
void dbg_init(ISACTMap *pmmap, void *icounter, int tsim);
DbgL *dbg_obj();
void dbg_deinit();

	//actions to perform, when simulation ended (stop_sim() or end of program or error)
void sim_exit();
	//actions to perform when simulation pause is activated
void dbg_pause();
	//actions to do at simulation step when stepping
void dbg_step();
	//actions to do at simulation substep when stepping
void dbg_substep();
	//actions to perform when program activates breakpoint
void dbg_breakpoint(unsigned int addr);
	//actions to perform when program activates watchpoint
void dbg_watchpoint(unsigned int addr);

// TODO: mas: 011106 - is the define necessary?
#ifdef RUN_DBG
	//switches debugging on/off
void dbg_active(bool active);

/*	//starts simulation (used only after initialization)
void start_sim();
	//stops simulation
void stop_sim();
	*/
	//pauses simulation after finishing actual instruction
void dbg_pause_sim();
	//pauses simulation after finishing actual subinstruction
void dbg_pause_sim_sub();

	//instruction stepping on/off
void dbg_stepping(bool enabled);

// TODO: will be supstepping supported in the IDE?

	//subinstruction stepping on/off
void dbg_stepping_sub(bool enabled);
	//continues simulation (after pause, step, substep)
void dbg_continue();
	//continues simulation from given address (after pause, step, substep)
	//finishes actual instruction
void dbg_continue(unsigned int addr);

	//sets program breakpoint to address data, enabled/disabled according to second parametr
	//returns false if breakpoint already exists
bool dbg_set_breakpoint(unsigned int addr, bool enabled);
	//changes state of breakpoint at address addr
	//returns false if breakpoint does not exists
bool dbg_change_breakpoint(unsigned int addr, bool enabled);
	//removes breakpoint at address addr, if it doesnt exists does nothing
void dbg_remove_breakpoint(unsigned int addr);

	//sets data watchpoint to address data, enabled/disabled according to second parametr
	//returns false if breakpoint already exists
bool dbg_set_watchpoint(unsigned int addr, bool enabled);
	//changes state of watchpoint at address addr
	//returns false if watchpoint does not exists
bool dbg_change_watchpoint(unsigned int addr, bool status);
	//removes watchpoint at address addr, if it doesnt exists does nothing
void dbg_remove_watchpoint(unsigned int addr);

	//returns data at address addr
unsigned int dbg_get_mem_data(unsigned int addr);
	//sets memory at address addr to value data
void dbg_set_mem_data(unsigned int addr, unsigned int data);
	//fills allocated array (length size) data with values from memory (starting at address addr)
void dbg_get_mem_data_arr(unsigned int addr, int size, unsigned int *data);
	//sets memory from address addr to values in array data, number of values defined by size
void dbg_set_mem_data_arr(unsigned int addr, int size, unsigned int *data);

// TODO: 011106 - move the statistics functions into the statics library
//--------------------------------------------------------------------------
	//returns TStat for mapped memory location addr
TStat dbg_get_mem_stat(unsigned int addr);
	//returns array of TStat for size memory values starting at address addr
void dbg_get_mem_stat_arr(unsigned int addr, int size, TStat *stats);
	//resets statistics for memory address addr
void dbg_reset_mem_stat(unsigned int addr);
	//resets statistics for size memory values starting at address addr
void dbg_reset_mem_stat_arr(unsigned int addr, int size);
//---------------------------------------------------------------------------

#endif
	//returns true if actual pc value has breakpoint
bool dbg_is_breakpoint();
	//returns true if any watchpoint was activated
bool dbg_is_watchpoint();


#endif /*SIM_DBG_H_*/
