/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

/////////////////////////////////////////////////////////////////////
//
//  standard exceptions in object file.
//
//  author:  Libor Vasicek, xvasic15@stud.fit.vutbr.cz
//  created: 22.02.2006
//
//////////////////////////////////////////////////////////////////////

#ifndef __EXCEPTIONS_H__
#define __EXCEPTIONS_H__

// standard exceptions
#include <iostream>
#include <exception>
#include <stdexcept>
#include <sstream>
#include <string>

using namespace std;

namespace ObjectFile
{
    //! Obecna vyjimka.
    class general_error : public exception
    {
    public:
        ~general_error() throw()
        {
        }

        general_error(string sMessage = "")
        {
            m_sMessage = string("General error: ") + sMessage;
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

    private:
        string     m_sMessage;
    };

    //! Vyjimka zpusobena chybou pri praci se soubory.
    class file_error : public exception
    {
    public:
        ~file_error() throw()
        {
        }

        file_error(string sMessage = "") :
            m_sMessage(sMessage)
        {
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

    private:
        string     m_sMessage;
    };
/*
    class unexpected_eol : public exception
    {
    public:
        virtual const char* what() const
        {
            return "Unexpected end of file";
        }
    };

    class invalid_file : public exception
    {
    public:
        virtual const char* what() const
        {
            return "File does not open";
        }
    };
*/

    //! Vyjimka spatneho vstupniho formatu.
    class invalid_format : public exception
    {
    public:
        ~invalid_format() throw()
        {
        }

        invalid_format(string sMessage = "Invalid format") :
            m_sMessage(sMessage)
        {
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

    private:
        string     m_sMessage;
    };

    //! Vyjimka zpusobena syntaktickou chybou.
    class syntax_error : public exception
    {
    public:
        ~syntax_error() throw()
        {
        }

        syntax_error(int nLine, string sMessage = "Syntax error") :
            m_nLine(nLine)
        {
            ostringstream error;
            error << "Line " << m_nLine << ": " << sMessage;
            m_sMessage = error.str();
        }

        virtual const char* what() const throw()
        {
            return m_sMessage.c_str();
        }

        inline int line_error()
        {
            return m_nLine;
        }

    private:
        int        m_nLine;
        string     m_sMessage;
    };
}

#endif //__EXCEPTIONS_H__
