/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version number    Header/source file for the project   "file name"     *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/


#ifndef _ISIML_H_
#define _ISIML_H_

#include <string>
#include <map>
using namespace std;

#include "isacctypes.h"
#include "res_decls.h"
#include "isimlcrc32.h"
#include "objectfile.h"
using namespace ObjectFile;

// class of instruction simulation library
class ISimL
{
private:
	string m_aux_cr_fnc_name;	// aux. function's name which contain codingroot section  
	string m_aux_cr_dec_fnc_name;	// aux. decoding function's name
	int m_aux_cr_dec_fnc_inst_addr;		// instruction's address used inside codingroot section

	typedef map <int,string> t_instr_behav;		// instrucion behavior - int is the instruction adress in the memory
	typedef map <string,t_instr_behav> t_crsec_decfnc;	// instruction decoding function
	map<string,t_crsec_decfnc> m_crsec_decfnc;	// operation with codingroot section containing all decoding instance
	
	CObjectFile* m_pObjFile;
	ISACTMapFastSim *m_fast_memmap;
	ISACTMapSlowSim *m_slow_memmap;
	unsigned int *m_fast_icounter;
	TRegister*m_slow_icounter;
	int m_tsim;
	string m_ifname;
	bool m_sim_gen_finished;
	int m_instr_counter;
	int m_nActSection;
	int m_nIncrement;
public:
	isaccint m_instr;				// instruction for parsing
	int m_nActBit;					// index inside the instruction
	int m_nCrc32;
	char buff[255];	// temporaly buffer used in generated yacc grammar
private:
	void write_beh_file_end();
	inline int updatecrc32(const char octet, int *crc )
	{
		return isimlcrc32tab[(m_nCrc32 ^ octet) & 0xff] ^ (*crc >> 8);
	}
	void init_instr_counter();
public:
	ISimL();
	~ISimL();
	void init(ISACTMap *pmmap, void *icounter, char *ifname, int tsim);
	void deinit();
	void load_file(string sfilename);	
	bool load_memory();
	void init_progc();
	void beginbeh();
	void endbeh();
	int sim_getbytes();
	bool sim_gen_finished();
	bool cmpsimsetup_h_binapp_record();	
	int getcrc32(const char* sfilename);

	void set_cr_fnc_name(char *cr_fnc_name);
	// function's body of inst_exec's compiled simulator
	void set_aux_crsec_param(char *cr_fnc_name, char *cr_inst_dec_fnc_name,int instr_addr);
	void append_instr_behav(char *instr_behav);
};

// initialisation of the library
void isiml_init(ISACTMap *pmmap, void *icounter, char *ifname, int tsim);
// retrieve instance of the library object
ISimL *isiml_obj();
// destruction of library object
void isiml_deinit();
// set new instruction
void isiml_scan_setinstr(isaccint instr);
// lexical analyser for interpreted simulator
int isiml_isimyylex();
// function used for creation of the compiled simulator
void isiml_set_aux_crsec_param(char *cr_fnc_name, char *cr_inst_dec_fnc_name,int instr_addr);
void isiml_append_instr_behav(char *instr_behav);
char *isiml_buff();

#endif /*_ISIML_H_*/
