/******************************************************************************
 *      "Copyright (C) 2006, ApS s.r.o Brno, All Rights Reserved"             *
 ******************************************************************************
 *============================================================================*
 *   Version "0.1"    Header/source file for the project   "msiprotl.h"       *
 *----------------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS                               *
 *----------------------------------------------------------------------------*
 *============================================================================*/

#ifndef MSIPROTL_H_
#define MSIPROTL_H_

//============================================================
//				MSI protocol interface
//============================================================
#include <vector>
#include <map>
#include <string>
#include <iostream>
#include "xmltransutils.h"
#include "socket.h"

//how many simulators can connect
#define MAX_CONN  10
//simname, <ip, port>
//address table eg: 192.168.2.1:3500
typedef std::pair<std::string,int> tAddress;
typedef std::map<std::string,tAddress> tsimTable;
	
typedef enum { MODIFIED, SHARED, INVALID, MSISTATECOUNT } tResState;
/**
 * This class implements the MSI protocol. It contains methods required for reading
 * and writing shared resources. Also contains socketTable - the table that binds simulator
 * to socket and lastWrite - table that holds the information which simulator made last
 * change to the shared resource
 * @version 1.0
 * @created 23-Apr-2007 13:24:45
 */
class MSIL
{
	
public:
	/**
     * Common structure used to send and receive messages
     *
     */
	ShContainer sh;
	/**
    * Socket used to send requests to other simulators
    *
    */
	Socket *writeSocket[MAX_CONN];
    
     /**
      * Table to bind simulator name to socket pointer 
      * This socket is used to send requests to particular simulator
      *
      */
	std::map<std::string, Socket*> socketTable;
    /**
     * Table to store which simulator made last change for each shared resource.
     *
     */
	// <resname, simname>
	std::map<std::string,std::string> lastWrite;
	
	char *simName;
public:
    /**
     * Default constructor, Initializes members
     *
     */
	MSIL(char *simname);
	virtual ~MSIL();
	/**
    * Creates required sockets and connects to other simulators
    */
	void sim_connect(tsimTable simTable);
    //add type info or create a new method for other resources type (memory and pipe)
    /**
     * Returns the actual value of shared resource.
     * When its necessary it ask the remote simulator for value
     */
	int read_res(char *resname);
    /**
     * Writes new value to shared resource.
     * Send broadcast to other simulators if needed.
     */
	void write_res(char *resname);
    /**
     * Broadcast notify message of end simulation.
     *
     */
	void end_sim(char *simname);
    /**
    * Generic broadcast.
    */
	void broadcast(ShContainer sh);
};

#endif // MSIPROTL
