#ifndef SWTOUTL_H_
#define SWTOUTL_H_

#include <exception>

using namespace std;

// structure of the software tools output in the XML form
/***
 * <SWTOUT>
 * 		<SWTSTATE> ... </SWTSTATE>
 * 		<SWTSTATEPARAM> ... </SWTSTATEPARAM>
 * 		<SWTSTATEPARAM> ... </SWTSTATEPARAM>
 * 		<SWTSTATEPARAM> ... </SWTSTATEPARAM>
 * 	</SWTOUT>
 * */
static const char *SWTIOL_XML_TAG_OUT[2]={"<SWTOUT>","</SWTOUT>"};
static const char *SWTIOL_XML_TAG_STATE[2]={"<SWTSTATE>","</SWTSTATE>"};
static const char *SWTIOL_XML_TAG_PARAMS[2]={"<SWTSTATEPARAM>","</SWTSTATEPARAM>"};
static const int SWTIOL_OPEN_TAG = 0;
static const int SWTIOL_CLOSE_TAG = 1;


// store some attributes
class Swtiol
{
public:
	char *m_warnmark;		// mark identifies the waring state
	char *m_errmark;		// mark identifies the error state
public:
	Swtiol(char *warnmark,char *errmark);
	~Swtiol();
	bool packreport(const char *inbuffer, char *outbuff);
};

// setup of library
/**
 * function initialise the library
 * @param okmark is the identification of the ok state in output of software tools
 * @param okmark is the identification of the warning state in output of software tools
 * @param okmark is the identification of the error state in output of software tools
 * */
void swtiol_init(char *warnmark,char *errmark);
void swtiol_deinit();

void swtiol_argpars_PI1(int argc, char **argv, char **a);
void swtiol_argpars_PO1(int argc, char **argv, char **a);
void swtiol_argpars_P2(int argc, char **argv, char **a, char **b);
void swtiol_argpars_P3(int argc, char **argv, char **a, char **b, char **c);
void swtiol_argpars_P2_ISACRTL(int argc, char **argv, char **a, char **b);
void swtiol_argpars_WP3(int argc, char **argv, char **warn, char **a, char **b);
void swtiol_argpars_TPI2(int argc, char **argv, char **a, char **b);
void swtiol_argpars_TP2(int argc, char **argv, char **a, char **b, char **c);
void swtiol_argpars_P4_ISACRTL(int argc, char **argv, char **a, char **b,char **c,char **d);
void swtiol_argpars_P4_RTLISAC(int argc, char **argv, char **a, char **b,char **c,char **d);
void swtiol_argpars_P3_RTLEMBEXT(int argc, char **argv, char **a, char **b,char **c);
void swtiol_argpars_P4_GENINSTRTOOL(int argc, char **argv, char **a, char **b,char **c, bool *d);

/**
 * create the packet of error's report for the input
 * @param input is the input
 * @param outputbuff is the buffer which contains the XML output
 * */
bool swtiol_pack_err(const char *inbuffer, char *outbuff);


/**
 * create the packet of ok report for the input
 * @param input is the input
 * @param outputbuff is the buffer which contains the XML output
 * */
bool swtiol_pack_ok(char *outbuff);


/**
 * predefined software tool error handling
 * @param e is teh exception
 * */
void swtiol_swt_errhandling(exception & e);

#endif /*SWTOUTL_H_*/
